/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image.ISizedImageLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image.SizedImageEditControl;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.ImageIEContents;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class SizedImageEditViewer
extends InfoElementAbstractEditViewer {
    SizedImageEditControl control;
    private SaveFeatureChangeDelayed saveWidthChangeDelayed = new SaveFeatureChangeDelayed();
    private SaveFeatureChangeDelayed saveHeightChangeDelayed = new SaveFeatureChangeDelayed();

    public SizedImageEditViewer(Composite parent) {
        this(parent, 0);
    }

    public SizedImageEditViewer(Composite parent, int style) {
        this(new SizedImageEditControl(parent, style));
    }

    public SizedImageEditViewer(SizedImageEditControl imageIEComposite) {
        this.control = imageIEComposite;
        this.control.getLoadButton().addSelectionListener((SelectionListener)new LoadSelectionAdapter());
        this.control.getResetButton().addSelectionListener((SelectionListener)new ResetSelectionAdapter());
        this.control.getWidthSpinner().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newValue;
                int oldValue = ((ISizedImageLabelProvider)SizedImageEditViewer.this.getLabelProvider()).getWidth(SizedImageEditViewer.this.getInput());
                if (oldValue != (newValue = SizedImageEditViewer.this.control.getWidthSpinner().getSelection())) {
                    SizedImageEditViewer.this.saveWidthChangeDelayed.setValues(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, newValue);
                    Display.getDefault().timerExec(800, (Runnable)SizedImageEditViewer.this.saveWidthChangeDelayed);
                }
            }
        });
        this.control.getHeightSpinner().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newValue;
                int oldValue = ((ISizedImageLabelProvider)SizedImageEditViewer.this.getLabelProvider()).getHeight(SizedImageEditViewer.this.getInput());
                if (oldValue != (newValue = SizedImageEditViewer.this.control.getHeightSpinner().getSelection())) {
                    SizedImageEditViewer.this.saveHeightChangeDelayed.setValues(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, newValue);
                    Display.getDefault().timerExec(800, (Runnable)SizedImageEditViewer.this.saveHeightChangeDelayed);
                }
            }
        });
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ISizedImageLabelProvider labelProvider = (ISizedImageLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            byte[] bytes = labelProvider.getImageBytes(element);
            int width = labelProvider.getWidth(element);
            int height = labelProvider.getHeight(element);
            if (!this.control.isDisposed()) {
                this.control.getWidthSpinner().setSelection(width);
                this.control.getHeightSpinner().setSelection(height);
                this.control.setImageBytes(bytes);
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ISizedImageLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        Assert.isTrue((this.getPropertyModifier() != null ? 1 : 0) != 0, (String)"SizedImageViewer must have a property modifier when input is set.");
        super.setInput(input);
        Assert.isTrue((boolean)(input instanceof ImageIE), (String)"Input of SizedImageViewer must be of ImageIE type.");
    }

    private final class LoadSelectionAdapter
    extends SelectionAdapter {
        private LoadSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ResourceDialog dialog = new ResourceDialog(SizedImageEditViewer.this.control.getShell(), "Select image...", 4100);
            if (dialog.open() == 0) {
                URI imageUri = (URI)dialog.getURIs().get(0);
                try {
                    InputStream inputStream = URIConverter.INSTANCE.createInputStream(imageUri);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    byte[] bytes = outputStream.toByteArray();
                    ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(bytes));
                    ImageIEContents imageContents = InfoelementsFactory.eINSTANCE.createImageIEContents();
                    imageContents.setContents(outputStream.toByteArray());
                    SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, imageContents);
                    SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, imageData.width);
                    SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, imageData.height);
                    SizedImageEditViewer.this.initializeViewer();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (SWTException e2) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "es.upv.dsic.issi.dplfw.infoelements.editorfragments", e2.getLocalizedMessage(), (Throwable)e2), 5);
                }
            }
        }
    }

    private final class ResetSelectionAdapter
    extends SelectionAdapter {
        private ResetSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, null);
            SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, 0);
            SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, 0);
            SizedImageEditViewer.this.initializeViewer();
        }
    }

    private final class SaveFeatureChangeDelayed
    implements Runnable {
        private Object feature;
        private Object value;

        private SaveFeatureChangeDelayed() {
        }

        @Override
        public void run() {
            if (SizedImageEditViewer.this.getInput() != null && this.feature != null && this.value != null) {
                SizedImageEditViewer.this.getPropertyModifier().setValue(SizedImageEditViewer.this.getInput(), this.feature, this.value);
            }
        }

        public void setValues(Object feature, Object value) {
            this.feature = feature;
            this.value = value;
        }
    }
}

