/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SizedImageEditControl
extends Composite {
    private Spinner heightSpinner;
    private Spinner widthSpinner;
    private Label imageLabel;
    private Button loadButton;
    private Button resetButton;
    private Image image;
    private Composite imageComposite;
    private Composite modifiersComposite;
    private boolean needsReload = false;
    private int lastWidth;
    ResizeListener resizeListener = new ResizeListener();
    private int widthDifference;
    private static int DEFAULT_COMPOSITE_MARGIN = 5;
    private Composite editComposite;
    private Button keepAspectRatioButton;

    public SizedImageEditControl(Composite parent, int style) {
        super(parent, style);
        this.enableScrollsInParents();
        this.setLayout((Layout)new TableWrapLayout());
        this.editComposite = new Composite((Composite)this, 0);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.makeColumnsEqualWidth = false;
        this.editComposite.setLayout((Layout)tableWrapLayout);
        this.editComposite.setLayoutData((Object)new TableWrapData(256));
        this.imageComposite = new Composite(this.editComposite, 0x800800);
        this.imageComposite.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout imageCompositeLayout = new TableWrapLayout();
        imageCompositeLayout.topMargin = 0;
        this.imageComposite.setLayout((Layout)imageCompositeLayout);
        Composite dummy = new Composite(this.imageComposite, 0);
        dummy.setLayoutData((Object)new TableWrapData(256));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        dummy.setLayout((Layout)layout);
        Composite dummyDummyComposite = new Composite(dummy, 0);
        GridData data = new GridData();
        data.widthHint = 1;
        data.heightHint = 0;
        dummyDummyComposite.setLayoutData((Object)data);
        this.imageLabel = new Label(this.imageComposite, 0);
        this.imageLabel.setLayoutData((Object)new TableWrapData(4));
        this.modifiersComposite = new Composite(this.editComposite, 0);
        this.modifiersComposite.setLayoutData((Object)new TableWrapData());
        this.modifiersComposite.setLayout((Layout)new TableWrapLayout());
        this.loadButton = new Button(this.modifiersComposite, 8);
        this.loadButton.setText("Load image...");
        this.loadButton.setLayoutData((Object)new TableWrapData(256));
        this.resetButton = new Button(this.modifiersComposite, 8);
        this.resetButton.setText("Delete image");
        this.resetButton.setLayoutData((Object)new TableWrapData(256));
        new Label(this.modifiersComposite, 0);
        Label prefLabel = new Label(this.modifiersComposite, 0);
        prefLabel.setText("Preferred image size:");
        Composite sizesComposite = new Composite(this.modifiersComposite, 0);
        TableWrapLayout sizesCompositeLayout = new TableWrapLayout();
        sizesCompositeLayout.numColumns = 2;
        sizesCompositeLayout.makeColumnsEqualWidth = false;
        sizesCompositeLayout.topMargin = 5;
        sizesCompositeLayout.bottomMargin = 5;
        sizesCompositeLayout.leftMargin = 10;
        sizesCompositeLayout.rightMargin = 10;
        sizesCompositeLayout.horizontalSpacing = 10;
        sizesComposite.setLayout((Layout)sizesCompositeLayout);
        Label widthLabel = new Label(sizesComposite, 0);
        widthLabel.setText("Width:");
        this.widthSpinner = new Spinner(sizesComposite, 2048);
        this.widthSpinner.setLayoutData((Object)new TableWrapData(256));
        this.widthSpinner.setMinimum(-1);
        this.widthSpinner.setMaximum((int)Math.pow(2.0, 13.0));
        this.widthSpinner.setToolTipText("Preferred width to display the image in pixels. Use '-1' to set the value to the image's actual width.");
        Label heightLabel = new Label(sizesComposite, 0);
        heightLabel.setText("Height:");
        this.heightSpinner = new Spinner(sizesComposite, 2048);
        this.heightSpinner.setLayoutData((Object)new TableWrapData(256));
        this.heightSpinner.setMinimum(-1);
        this.heightSpinner.setMaximum((int)Math.pow(2.0, 13.0));
        this.heightSpinner.setToolTipText("Preferred height to display the image in pixels. Use '-1' to set the value to the image's actual height.");
        this.keepAspectRatioButton = new Button(sizesComposite, 32);
        this.keepAspectRatioButton.setText("Keep aspect ratio");
        this.keepAspectRatioButton.setSelection(true);
        this.keepAspectRatioButton.setLayoutData((Object)new TableWrapData(256, 16, 1, 2));
        this.heightSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SizedImageEditControl.this.updateWidthSpinnerFromHeight();
            }

            public void widgetSelected(SelectionEvent e) {
                SizedImageEditControl.this.updateWidthSpinnerFromHeight();
            }
        });
        this.widthSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SizedImageEditControl.this.updateHeightSpinnerFromWidth();
            }

            public void widgetSelected(SelectionEvent e) {
                SizedImageEditControl.this.updateHeightSpinnerFromWidth();
            }
        });
        this.addListener(11, this.resizeListener);
        this.layout(true, true);
        this.widthDifference = Math.max(this.modifiersComposite.getSize().x + DEFAULT_COMPOSITE_MARGIN * 8 + 2, 1);
        this.createDisposeListener();
    }

    private void updateHeightSpinnerFromWidth() {
        if (this.widthSpinner.getSelection() < 0) {
            this.widthSpinner.setSelection(this.image.getImageData().width);
        } else if (this.keepAspectRatioButton.getSelection() && this.image != null) {
            float ratio = (float)this.image.getImageData().height / (float)this.image.getImageData().width;
            int newValue = Math.round((float)this.widthSpinner.getSelection() * ratio);
            if (newValue != this.heightSpinner.getSelection()) {
                this.heightSpinner.setSelection(newValue);
            }
        }
    }

    private void updateWidthSpinnerFromHeight() {
        if (this.heightSpinner.getSelection() < 0) {
            this.heightSpinner.setSelection(this.image.getImageData().height);
        } else if (this.keepAspectRatioButton.getSelection() && this.image != null) {
            float ratio = (float)this.image.getImageData().width / (float)this.image.getImageData().height;
            int newValue = Math.round((float)this.heightSpinner.getSelection() * ratio);
            if (newValue != this.widthSpinner.getSelection()) {
                this.widthSpinner.setSelection(newValue);
            }
        }
    }

    private void enableScrollsInParents() {
        Composite parent = this.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)parent).setAlwaysShowScrollBars(true);
            }
            parent = parent.getParent();
        }
    }

    public Button getResetButton() {
        return this.resetButton;
    }

    public Button getLoadButton() {
        return this.loadButton;
    }

    public Button getKeepAspectRatioButton() {
        return this.keepAspectRatioButton;
    }

    public synchronized void setImageBytes(byte[] bytes) {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = new Image((Device)this.getDisplay(), (InputStream)new ByteArrayInputStream(bytes));
        this.refresh();
    }

    private void internalImageUpdate() {
        if (this.image != null) {
            int maxWidth = Math.max(this.getSize().x - this.widthDifference, 1);
            if (this.needsReload || this.lastWidth != maxWidth) {
                this.needsReload = false;
                if (this.imageLabel.getImage() != null) {
                    this.imageLabel.getImage().dispose();
                }
                Image newImage = this.image.getBounds().width > maxWidth ? SWTUtil.createResizedImage((Image)this.image, (int)Math.max(maxWidth, 1)) : new Image((Device)this.getShell().getDisplay(), this.image, 0);
                this.imageLabel.setImage(newImage);
                this.imageComposite.setLayoutData((Object)new TableWrapData(256));
                this.imageComposite.setBackground(null);
                this.lastWidth = newImage.getBounds().width;
                this.setSize(this.computeSize(this.getSize().x, -1));
                this.layout(true, true);
            }
        }
    }

    public Spinner getWidthSpinner() {
        return this.widthSpinner;
    }

    public Spinner getHeightSpinner() {
        return this.heightSpinner;
    }

    public void refresh() {
        this.internalImageUpdate();
        this.needsReload = true;
        this.notifyListeners(11, new Event());
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SizedImageEditControl.this.image != null) {
                    SizedImageEditControl.this.image.dispose();
                }
                if (SizedImageEditControl.this.imageLabel != null && SizedImageEditControl.this.imageLabel.getImage() != null) {
                    SizedImageEditControl.this.imageLabel.getImage().dispose();
                }
            }
        });
    }

    private final class ResizeListener
    implements Listener {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!SizedImageEditControl.this.isDisposed()) {
                    SizedImageEditControl.this.setRedraw(false);
                    SizedImageEditControl.this.refresh();
                    ResizeListener.this.resize = false;
                    SizedImageEditControl.this.setRedraw(true);
                }
            }
        };
        private volatile boolean resize = false;

        private ResizeListener() {
        }

        public void handleEvent(Event event) {
            if (!this.resize) {
                if (SizedImageEditControl.this.imageLabel != null && SizedImageEditControl.this.imageLabel.getImage() != null) {
                    int height = ((SizedImageEditControl)SizedImageEditControl.this).imageLabel.getSize().y + DEFAULT_COMPOSITE_MARGIN * 2 + 4;
                    SizedImageEditControl.this.imageLabel.getImage().dispose();
                    SizedImageEditControl.this.imageLabel.setImage(null);
                    TableWrapData tableWrapData = new TableWrapData(256);
                    tableWrapData.heightHint = height;
                    SizedImageEditControl.this.imageComposite.setLayoutData((Object)tableWrapData);
                    SizedImageEditControl.this.imageComposite.setBackground(Display.getDefault().getSystemColor(22));
                    SizedImageEditControl.this.imageLabel.setBackground(Display.getDefault().getSystemColor(22));
                }
                SizedImageEditControl.this.getShell().getDisplay().timerExec(250, this.runnable);
            }
            this.resize = true;
        }
    }
}

