/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image.ISizedImageLabelProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image.SizedImageDisplayControl;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.ImageIEContents;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SizedImageDisplayViewer
extends InfoElementAbstractDisplayViewer {
    SizedImageDisplayControl control;

    public SizedImageDisplayViewer(Composite parent, int style) {
        this(new SizedImageDisplayControl(parent, style));
    }

    public SizedImageDisplayViewer(Composite parent) {
        this(parent, 0);
    }

    public SizedImageDisplayViewer(SizedImageDisplayControl imageIEComposite) {
        this.control = imageIEComposite;
    }

    @Override
    protected void initializeViewer() {
        IIEContentProvider contentProvider = (IIEContentProvider)this.getContentProvider();
        ISizedImageLabelProvider labelProvider = (ISizedImageLabelProvider)this.getLabelProvider();
        InfoElement element = contentProvider.getElement(this.getInput());
        if (element != null) {
            byte[] bytes = labelProvider.getImageBytes(element);
            int width = labelProvider.getWidth(element);
            int height = labelProvider.getHeight(element);
            if (!this.control.isDisposed()) {
                this.control.setImageBytes(bytes);
                this.control.setWidth(width);
                this.control.setHeight(height);
                this.control.setTitle(element.getTitle());
                this.control.setDescription(element.getDescription());
                this.control.refresh();
            }
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IIEContentProvider));
        super.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ISizedImageLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        Assert.isTrue((boolean)(input instanceof ImageIE), (String)"Input of SizedImageViewer must be of ImageIE type.");
        ImageIE imageIE = (ImageIE)input;
        imageIE.eAdapters().add((Object)new AdapterImpl(){
            private Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!(this).SizedImageDisplayViewer.this.control.isDisposed()) {
                        (this).SizedImageDisplayViewer.this.control.refresh();
                    }
                }
            };

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIE_ImageContents()) {
                    ImageIEContents imageIEContents = (ImageIEContents)msg.getNewValue();
                    if (imageIEContents != null) {
                        SizedImageDisplayViewer.this.control.setImageBytes(imageIEContents.getContents());
                    } else {
                        SizedImageDisplayViewer.this.control.setImageBytes(null);
                    }
                    Display.getDefault().asyncExec(this.runnable);
                } else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIE_DisplayHeight()) {
                    SizedImageDisplayViewer.this.control.setHeight((Integer)msg.getNewValue());
                    Display.getDefault().asyncExec(this.runnable);
                } else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIE_DisplayWidth()) {
                    SizedImageDisplayViewer.this.control.setWidth((Integer)msg.getNewValue());
                    Display.getDefault().asyncExec(this.runnable);
                } else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title()) {
                    SizedImageDisplayViewer.this.control.setTitle(msg.getNewStringValue());
                    Display.getDefault().asyncExec(this.runnable);
                } else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Description()) {
                    SizedImageDisplayViewer.this.control.setDescription(msg.getNewStringValue());
                    Display.getDefault().asyncExec(this.runnable);
                }
            }
        });
    }
}

