/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SizedImageDisplayControl
extends Composite {
    private static final int MARGIN_SIZE = 20;
    private Composite imageComposite;
    private Label imageLabel;
    private Image image;
    private FormText formText;
    private int width;
    private int height;
    private String title;
    private String description;

    public SizedImageDisplayControl(Composite parent, int style) {
        super(parent, style);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 20;
        layout.rightMargin = 20;
        layout.topMargin = 20;
        layout.bottomMargin = 20;
        this.setLayout((Layout)layout);
        this.formText = new FormText((Composite)this, 66);
        TableWrapData layoutData = new TableWrapData(256);
        this.formText.setLayoutData((Object)layoutData);
        this.imageComposite = new Composite((Composite)this, 0);
        this.imageComposite.setLayoutData((Object)new TableWrapData(256));
        this.imageComposite.setLayout((Layout)new TableWrapLayout());
        Composite dummy = new Composite(this.imageComposite, 0);
        dummy.setLayoutData((Object)new TableWrapData(256));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        dummy.setLayout((Layout)gridLayout);
        this.imageLabel = new Label(this.imageComposite, 0);
        this.imageLabel.setLayoutData((Object)new TableWrapData(4));
        this.createDisposeListener();
    }

    public void setImageBytes(byte[] bytes) {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = bytes != null ? new Image((Device)this.getDisplay(), (InputStream)new ByteArrayInputStream(bytes)) : null;
        this.refresh();
    }

    public void setWidth(int width) {
        this.width = width;
        this.refresh();
    }

    public void setHeight(int height) {
        this.height = height;
        this.refresh();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public synchronized void refresh() {
        if (this.image != null && !this.image.isDisposed()) {
            this.replaceImage(SWTUtil.createResizedImage((Image)this.image, (int)Math.max(this.width, 1), (int)Math.max(this.height, 1)));
        } else {
            this.replaceImage(null);
        }
        if (!this.formText.isDisposed()) {
            this.formText.setFont(SWTUtil.getDefaultTextFont());
            this.formText.setFont("TITLE", SWTUtil.getDefaultTitleFont());
            this.formText.setText(this.buildFormContent(), true, false);
        }
    }

    private String buildFormContent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form>");
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            stringBuilder.append("<p><span font=\"TITLE\">");
            stringBuilder.append(this.title);
            stringBuilder.append("</span></p><p></p>");
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            stringBuilder.append("<p>");
            stringBuilder.append(this.description);
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</form>");
        return stringBuilder.toString();
    }

    private synchronized void replaceImage(Image image) {
        if (!this.imageLabel.isDisposed() && this.imageLabel != null) {
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.getImage().dispose();
            }
            this.imageLabel.setImage(image);
            this.imageLabel.setSize(this.imageLabel.computeSize(-1, -1));
            this.setSize(this.computeSize(this.imageComposite.getSize().x + 40, -1));
            this.layout(true, true);
        }
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!SizedImageDisplayControl.this.image.isDisposed() && SizedImageDisplayControl.this.image != null) {
                    SizedImageDisplayControl.this.image.dispose();
                }
                if (SizedImageDisplayControl.this.imageLabel != null && SizedImageDisplayControl.this.imageLabel.getImage() != null) {
                    SizedImageDisplayControl.this.imageLabel.getImage().dispose();
                }
            }
        });
    }
}

