/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.VariablesDialogFormPage;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class VariablesFormPage
extends FormPage {
    protected static final int MARGIN_WIDTH = 10;
    private InfoElement infoElement;
    private Text uuidText;
    private Text titleText;
    private DateTime creationDate;
    private Combo subjectCombo;
    private Text publisherText;
    private Combo languageCombo;
    private Text descriptionText;
    private TableViewer authorsViewer;
    private TableViewer variablesViewer;
    private FormToolkit toolkit;

    public VariablesFormPage(FormEditor editor, InfoElement infoElement) {
        super(editor, "es.upv.dsic.issi.dplfw.infoelements.presentation.EditInfoElementFormPage", "Variables");
        this.infoElement = infoElement;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        form.setText("Info Element Editor");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        this.toolkit.decorateFormHeading(form.getForm());
        this.createVariablesSection(form, this.toolkit);
    }

    private void createVariablesSection(ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 450);
        section.setText("Variables");
        section.setDescription("Variables list of the info element");
        section.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        section.setLayout((Layout)new TableWrapLayout());
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new TableWrapData(256));
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)sectionClient);
        GridData listGridData = new GridData();
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.grabExcessVerticalSpace = true;
        listGridData.horizontalAlignment = 4;
        listGridData.verticalAlignment = 4;
        listGridData.verticalSpan = 4;
        Table variablesTable = toolkit.createTable(sectionClient, 0);
        variablesTable.setLayoutData((Object)listGridData);
        this.variablesViewer = new TableViewer(variablesTable);
        this.variablesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.variablesViewer.setInput((Object)this.infoElement.getVariables());
        sectionClient.setData((Object)toolkit);
        Button newButton = toolkit.createButton(sectionClient, "New...", 8);
        newButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariablesDialogFormPage dialog = new VariablesDialogFormPage(VariablesFormPage.this.getSite().getShell());
                if (dialog.open() == 0) {
                    VariableIEContents varIE = InfoelementsFactory.eINSTANCE.createVariableIEContents();
                    varIE.setIdName(dialog.getName());
                    varIE.setDescription(dialog.getDescription());
                    Command command = AddCommand.create((EditingDomain)VariablesFormPage.this.getEditingDomain(), (Object)VariablesFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__VARIABLES, (Object)varIE);
                    if (command.canExecute()) {
                        VariablesFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    VariablesFormPage.this.variablesViewer.refresh();
                    VariablesFormPage.this.variablesViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getName()), true);
                }
            }
        });
        Button removeButton = toolkit.createButton(sectionClient, "Remove", 8);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)VariablesFormPage.this.variablesViewer.getSelection();
                if (selection.getFirstElement() != null) {
                    int index = VariablesFormPage.this.variablesViewer.getTable().getSelectionIndex();
                    Command command = RemoveCommand.create((EditingDomain)VariablesFormPage.this.getEditingDomain(), (Object)VariablesFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__VARIABLES, (Object)selection.getFirstElement());
                    if (command.canExecute()) {
                        VariablesFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    VariablesFormPage.this.variablesViewer.refresh();
                    if (VariablesFormPage.this.variablesViewer.getElementAt(index) != null) {
                        VariablesFormPage.this.variablesViewer.getTable().setSelection(index);
                    } else if (VariablesFormPage.this.variablesViewer.getElementAt(index - 1) != null) {
                        VariablesFormPage.this.variablesViewer.getTable().setSelection(index - 1);
                    }
                }
            }
        });
    }

    protected EditingDomain getEditingDomain() {
        return ((IEditingDomainProvider)this.getEditor()).getEditingDomain();
    }

    private final class ReadOnlyComboKeyListener
    implements KeyListener {
        private ReadOnlyComboKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            Combo combo = (Combo)e.getSource();
            if (e.keyCode == 27) {
                combo.setListVisible(false);
                return;
            }
            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008) {
                return;
            }
            if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000006 || e.keyCode == 0x1000005) {
                combo.setListVisible(true);
                return;
            }
            String stringCharacter = Character.toString(e.character);
            Point selection = combo.getSelection();
            combo.setListVisible(true);
            if (e.keyCode == 8 && selection.x == selection.y) {
                combo.setSelection(new Point(selection.x - 1, selection.y - 1));
                stringCharacter = "";
            } else if ((e.keyCode == 8 || e.keyCode == 127) && selection.x == 0) {
                combo.setSelection(new Point(0, 0));
                combo.setText("");
                stringCharacter = "";
            } else {
                combo.setSelection(selection);
            }
            String searchString = "";
            if (combo.getSelection().x == 0 && StringUtils.isNotEmpty((CharSequence)stringCharacter)) {
                searchString = stringCharacter;
            } else if (combo.getSelection().x == 0 && combo.getSelection().y == combo.getText().length()) {
                searchString = combo.getText();
            } else if (combo.getSelection().x == combo.getSelection().y) {
                searchString = String.valueOf(combo.getText().substring(0, combo.getSelection().x)) + stringCharacter;
            }
            int i = 0;
            while (i < combo.getItemCount()) {
                if (StringUtils.isNotEmpty((CharSequence)searchString) && combo.getItem(i).toLowerCase().startsWith(searchString.toLowerCase())) {
                    combo.setText(combo.getItem(i));
                    combo.select(i);
                    combo.setSelection(new Point(searchString.length(), searchString.length()));
                    break;
                }
                ++i;
            }
            if (e.character != '\u0000' && e.character != '\r' && e.character != '\n') {
                e.doit = false;
            }
        }
    }
}

