/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.AbstractContentFormPage;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PreviewFormPage
extends AbstractContentFormPage {
    static final String GENERIC_DISPLAY_DESCRIPTION = "Preview of the Info Element";
    Section previewSection;

    public PreviewFormPage(FormEditor editor, InfoElement infoElement) {
        this(editor, infoElement, "Preview");
    }

    public PreviewFormPage(FormEditor editor, InfoElement infoElement, String activityName) {
        super(editor, "es.upv.dsic.issi.dplfw.infoelements.presentation.EditContentFormPage", activityName);
        this.infoElement = infoElement;
    }

    protected void createFormContent(IManagedForm managedForm) {
        String description = null;
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Info Element Editor");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        form.setDelayedReflow(true);
        toolkit.decorateFormHeading(form.getForm());
        try {
            IConfigurationElement configElement = this.getConfigurationElementForIE(this.infoElement);
            this.previewSection = this.createSection(form, toolkit, configElement, false);
            if (this.previewSection != null) {
                this.previewSection.setText("Preview contents");
                description = configElement.getAttribute("displayDescription");
                this.previewSection.setDescription(description != null ? description : GENERIC_DISPLAY_DESCRIPTION);
                this.previewSection.setLayoutData((Object)new TableWrapData(256));
            }
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException(NLS.bind((String)"Unable to create previewer for {0}", (Object)this.infoElement.getClass().toString()), (Exception)e);
        }
        form.reflow(true);
    }

    @Override
    protected IIEDisplayViewer createViewer(Composite parent, ScrolledForm scrolledForm, FormToolkit toolkit, InfoElement infoElement, IConfigurationElement configElement) throws ClassNotFoundException {
        IIEDisplayViewer ieViewer = null;
        try {
            String viewerClassName = configElement.getAttribute("displayViewer");
            if (viewerClassName == null) {
                throw new ClassNotFoundException();
            }
            Class<?> viewerClass = Class.forName(viewerClassName);
            Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class, Integer.TYPE);
            ieViewer = (IIEDisplayViewer)viewerConstructor.newInstance(parent, 2048);
            IContentProvider contentProvider = (IContentProvider)configElement.createExecutableExtension("contentProvider");
            IBaseLabelProvider labelProvider = (IBaseLabelProvider)configElement.createExecutableExtension("labelProvider");
            ieViewer.setContentProvider(contentProvider);
            ieViewer.setLabelProvider(labelProvider);
            ieViewer.setInput(infoElement);
            if (ieViewer.getControl() instanceof Composite) {
                this.cascadeAdapt((Composite)ieViewer.getControl(), toolkit);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return ieViewer;
    }
}

