/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelements.ISO_Language;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MetadataFormPage
extends FormPage {
    private InfoElement infoElement;
    private Text uuidText;
    private Text titleText;
    private DateTime creationDate;
    private Combo subjectCombo;
    private Text publisherText;
    private Combo languageCombo;
    private Text descriptionText;
    private TableViewer authorsViewer;
    private TableViewer keywordsViewer;

    public MetadataFormPage(FormEditor editor, InfoElement infoElement) {
        super(editor, "es.upv.dsic.issi.dplfw.infoelements.presentation.EditInfoElementFormPage", "Metadata");
        this.infoElement = infoElement;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Info Element Editor");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        toolkit.decorateFormHeading(form.getForm());
        this.createBasicMetadataSection(form, toolkit);
        this.loadBasicMetadata();
        this.createAuthorsSection(form, toolkit);
        this.createKeywordsSection(form, toolkit);
    }

    private void createBasicMetadataSection(ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 450);
        section.setText("Basic metadata");
        section.setDescription("Basic metadata of the info element");
        section.setLayoutData((Object)new TableWrapData(256, 16, 1, 2));
        section.setLayout((Layout)new FillLayout());
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)sectionClient);
        GridData gdHSpan2 = new GridData();
        gdHSpan2.grabExcessHorizontalSpace = true;
        gdHSpan2.horizontalAlignment = 4;
        toolkit.createLabel(sectionClient, "UUID:");
        this.uuidText = toolkit.createText(sectionClient, "");
        this.uuidText.setEditable(false);
        this.uuidText.setEnabled(false);
        this.uuidText.setLayoutData((Object)new GridData(4, -1, true, false));
        toolkit.createLabel(sectionClient, "Title:");
        this.titleText = toolkit.createText(sectionClient, "");
        this.titleText.setLayoutData((Object)gdHSpan2);
        toolkit.createLabel(sectionClient, "Date of Creation:");
        this.creationDate = new DateTime(sectionClient, 268435492);
        this.creationDate.setLayoutData((Object)gdHSpan2);
        toolkit.adapt((Composite)this.creationDate);
        toolkit.createLabel(sectionClient, "Subject:");
        this.subjectCombo = new Combo(sectionClient, 4);
        String[] subjects = IESingleEditorPlugin.getDefault().getPreferenceStore().getString("P_SUBJECTS").split("\t");
        this.subjectCombo.add("");
        String[] stringArray = subjects;
        int n = subjects.length;
        int n2 = 0;
        while (n2 < n) {
            String subject = stringArray[n2];
            this.subjectCombo.add(subject);
            ++n2;
        }
        toolkit.adapt((Control)this.subjectCombo, false, false);
        this.subjectCombo.setLayoutData((Object)gdHSpan2);
        this.subjectCombo.addKeyListener((KeyListener)new ReadOnlyComboKeyListener());
        this.subjectCombo.setVisibleItemCount(10);
        toolkit.createLabel(sectionClient, "Publisher:");
        this.publisherText = toolkit.createText(sectionClient, "");
        this.publisherText.setLayoutData((Object)gdHSpan2);
        toolkit.createLabel(sectionClient, "Language:");
        this.languageCombo = new Combo(sectionClient, 4);
        stringArray = ISO_Language.values();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            this.languageCombo.add(lang.getLiteral());
            ++n2;
        }
        toolkit.adapt((Control)this.languageCombo, false, false);
        this.languageCombo.setLayoutData((Object)gdHSpan2);
        this.languageCombo.addKeyListener((KeyListener)new ReadOnlyComboKeyListener());
        this.languageCombo.setVisibleItemCount(10);
        toolkit.createLabel(sectionClient, "Description:");
        this.descriptionText = toolkit.createText(sectionClient, "", 578);
        GridData descTextGridData = new GridData(4, 4, true, true);
        descTextGridData.grabExcessHorizontalSpace = true;
        descTextGridData.grabExcessVerticalSpace = true;
        descTextGridData.horizontalAlignment = 4;
        descTextGridData.widthHint = 200;
        descTextGridData.heightHint = 100;
        this.descriptionText.setLayoutData((Object)descTextGridData);
        toolkit.adapt((Control)this.descriptionText, true, false);
    }

    private void createAuthorsSection(ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 450);
        section.setText("Authors");
        section.setDescription("Enter the authors which have contributed this Info Element to the repository.");
        section.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        section.setLayout((Layout)new TableWrapLayout());
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new TableWrapData(256));
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)sectionClient);
        GridData listGridData = new GridData();
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.grabExcessVerticalSpace = true;
        listGridData.horizontalAlignment = 4;
        listGridData.verticalAlignment = 4;
        listGridData.verticalSpan = 4;
        Table authorsTable = toolkit.createTable(sectionClient, 0);
        authorsTable.setLayoutData((Object)listGridData);
        this.authorsViewer = new TableViewer(authorsTable);
        this.authorsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.authorsViewer.setInput((Object)this.infoElement.getAuthor());
        Button newButton = toolkit.createButton(sectionClient, "New...", 8);
        newButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(MetadataFormPage.this.getSite().getShell(), "New Author", "Enter an author name:", "", null);
                if (dialog.open() == 0) {
                    Command command = AddCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, (Object)dialog.getValue());
                    if (command.canExecute()) {
                        MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    MetadataFormPage.this.authorsViewer.refresh();
                    MetadataFormPage.this.authorsViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getValue()), true);
                }
            }
        });
        Button removeButton = toolkit.createButton(sectionClient, "Remove", 8);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.authorsViewer.getSelection();
                if (selection.getFirstElement() != null) {
                    int index = MetadataFormPage.this.authorsViewer.getTable().getSelectionIndex();
                    Command command = RemoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, (Object)selection.getFirstElement());
                    if (command.canExecute()) {
                        MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    MetadataFormPage.this.authorsViewer.refresh();
                    if (MetadataFormPage.this.authorsViewer.getElementAt(index) != null) {
                        MetadataFormPage.this.authorsViewer.getTable().setSelection(index);
                    } else if (MetadataFormPage.this.authorsViewer.getElementAt(index - 1) != null) {
                        MetadataFormPage.this.authorsViewer.getTable().setSelection(index - 1);
                    }
                }
            }
        });
        Button upButton = toolkit.createButton(sectionClient, "Up", 8);
        upButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.authorsViewer.getSelection();
                int newPos = MetadataFormPage.this.infoElement.getAuthor().indexOf(selection.getFirstElement()) - 1;
                Command command = MoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, (Object)selection.getFirstElement(), (int)newPos);
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
                MetadataFormPage.this.authorsViewer.refresh();
            }
        });
        Button downButton = toolkit.createButton(sectionClient, "Down", 8);
        downButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.authorsViewer.getSelection();
                int newPos = MetadataFormPage.this.infoElement.getAuthor().indexOf(selection.getFirstElement()) + 1;
                Command command = MoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, (Object)selection.getFirstElement(), (int)newPos);
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
                MetadataFormPage.this.authorsViewer.refresh();
            }
        });
    }

    private void createKeywordsSection(ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 450);
        section.setText("Keywords");
        section.setDescription("Keywords describing this Info Element.Keywords are used when searching for Info Elements in the repository.");
        section.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        section.setLayout((Layout)new TableWrapLayout());
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayoutData((Object)new TableWrapData(256));
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)sectionClient);
        GridData listGridData = new GridData();
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.grabExcessVerticalSpace = true;
        listGridData.horizontalAlignment = 4;
        listGridData.verticalAlignment = 4;
        listGridData.verticalSpan = 4;
        Table keywordsTable = toolkit.createTable(sectionClient, 0);
        keywordsTable.setLayoutData((Object)listGridData);
        this.keywordsViewer = new TableViewer(keywordsTable);
        this.keywordsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.keywordsViewer.setInput((Object)this.infoElement.getKeywords());
        Button newButton = toolkit.createButton(sectionClient, "New...", 8);
        newButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(MetadataFormPage.this.getSite().getShell(), "New keyword", "Enter a new keyword:", "", null);
                if (dialog.open() == 0) {
                    Command command = AddCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, (Object)dialog.getValue());
                    if (command.canExecute()) {
                        MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    MetadataFormPage.this.keywordsViewer.refresh();
                    MetadataFormPage.this.keywordsViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getValue()), true);
                }
            }
        });
        Button removeButton = toolkit.createButton(sectionClient, "Remove", 8);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.keywordsViewer.getSelection();
                if (selection.getFirstElement() != null) {
                    int index = MetadataFormPage.this.keywordsViewer.getTable().getSelectionIndex();
                    Command command = RemoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, (Object)selection.getFirstElement());
                    if (command.canExecute()) {
                        MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                    }
                    MetadataFormPage.this.keywordsViewer.refresh();
                    if (MetadataFormPage.this.keywordsViewer.getElementAt(index) != null) {
                        MetadataFormPage.this.keywordsViewer.getTable().setSelection(index);
                    } else if (MetadataFormPage.this.keywordsViewer.getElementAt(index - 1) != null) {
                        MetadataFormPage.this.keywordsViewer.getTable().setSelection(index - 1);
                    }
                }
            }
        });
        Button upButton = toolkit.createButton(sectionClient, "Up", 8);
        upButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.keywordsViewer.getSelection();
                int newPos = MetadataFormPage.this.infoElement.getKeywords().indexOf(selection.getFirstElement()) - 1;
                Command command = MoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, (Object)selection.getFirstElement(), (int)newPos);
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
                MetadataFormPage.this.keywordsViewer.refresh();
            }
        });
        Button downButton = toolkit.createButton(sectionClient, "Down", 8);
        downButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MetadataFormPage.this.keywordsViewer.getSelection();
                int newPos = MetadataFormPage.this.infoElement.getKeywords().indexOf(selection.getFirstElement()) + 1;
                Command command = MoveCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, (Object)selection.getFirstElement(), (int)newPos);
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
                MetadataFormPage.this.keywordsViewer.refresh();
            }
        });
    }

    private void loadBasicMetadata() {
        if (this.infoElement.getUuid() != null) {
            this.uuidText.setText(this.infoElement.getUuid().toString());
        }
        if (this.infoElement.getTitle() != null) {
            this.titleText.setText(this.infoElement.getTitle());
        }
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__TITLE, (Object)((Text)e.getSource()).getText());
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        if (this.infoElement.getDateCreation() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.infoElement.getDateCreation());
            this.creationDate.setDate(cal.get(1), cal.get(2), cal.get(5));
        }
        this.creationDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.set(MetadataFormPage.this.creationDate.getYear(), MetadataFormPage.this.creationDate.getMonth(), MetadataFormPage.this.creationDate.getDay(), 0, 0, 0);
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__DATE_CREATION, (Object)cal.getTime());
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        if (this.infoElement.getSubject() != null) {
            this.subjectCombo.setText(this.infoElement.getSubject());
        }
        this.subjectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__SUBJECT, (Object)((Combo)e.getSource()).getText());
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        if (this.infoElement.getPublisher() != null) {
            this.publisherText.setText(this.infoElement.getPublisher());
        }
        this.publisherText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__PUBLISHER, (Object)((Text)e.getSource()).getText());
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        if (this.infoElement.getLanguage() != null) {
            this.languageCombo.setText(this.infoElement.getLanguage().getLiteral());
        }
        this.languageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__LANGUAGE, (Object)ISO_Language.get((String)((Combo)e.getSource()).getText()));
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        if (this.infoElement.getDescription() != null) {
            this.descriptionText.setText(this.infoElement.getDescription());
        }
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command command = SetCommand.create((EditingDomain)MetadataFormPage.this.getEditingDomain(), (Object)MetadataFormPage.this.infoElement, (Object)InfoelementsPackage.Literals.INFO_ELEMENT__DESCRIPTION, (Object)((Text)e.getSource()).getText());
                if (command.canExecute()) {
                    MetadataFormPage.this.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
    }

    protected EditingDomain getEditingDomain() {
        return ((IEditingDomainProvider)this.getEditor()).getEditingDomain();
    }

    private final class ReadOnlyComboKeyListener
    implements KeyListener {
        private ReadOnlyComboKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            Combo combo = (Combo)e.getSource();
            if (e.keyCode == 27) {
                combo.setListVisible(false);
                return;
            }
            if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008) {
                return;
            }
            if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000006 || e.keyCode == 0x1000005) {
                combo.setListVisible(true);
                return;
            }
            String stringCharacter = Character.toString(e.character);
            Point selection = combo.getSelection();
            combo.setListVisible(true);
            if (e.keyCode == 8 && selection.x == selection.y) {
                combo.setSelection(new Point(selection.x - 1, selection.y - 1));
                stringCharacter = "";
            } else if ((e.keyCode == 8 || e.keyCode == 127) && selection.x == 0) {
                combo.setSelection(new Point(0, 0));
                combo.setText("");
                stringCharacter = "";
            } else {
                combo.setSelection(selection);
            }
            String searchString = "";
            if (combo.getSelection().x == 0 && StringUtils.isNotEmpty((CharSequence)stringCharacter)) {
                searchString = stringCharacter;
            } else if (combo.getSelection().x == 0 && combo.getSelection().y == combo.getText().length()) {
                searchString = combo.getText();
            } else if (combo.getSelection().x == combo.getSelection().y) {
                searchString = String.valueOf(combo.getText().substring(0, combo.getSelection().x)) + stringCharacter;
            }
            int i = 0;
            while (i < combo.getItemCount()) {
                if (StringUtils.isNotEmpty((CharSequence)searchString) && combo.getItem(i).toLowerCase().startsWith(searchString.toLowerCase())) {
                    combo.setText(combo.getItem(i));
                    combo.select(i);
                    combo.setSelection(new Point(searchString.length(), searchString.length()));
                    break;
                }
                ++i;
            }
            if (e.character != '\u0000' && e.character != '\r' && e.character != '\n') {
                e.doit = false;
            }
        }
    }
}

