/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.AbstractContentFormPage;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementPropertyModifier;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EditFormPage
extends AbstractContentFormPage {
    private static final String GENERIC_EDIT_DESCRIPTION = "Edit de contents of the Info Element";
    private Section editSection;

    public EditFormPage(FormEditor editor, InfoElement imageIE, String tabText) {
        super(editor, "es.upv.dsic.issi.dplfw.infoelements.presentation.EditContentFormPage", tabText);
        this.infoElement = imageIE;
    }

    public EditFormPage(FormEditor editor, InfoElement imageIE) {
        this(editor, imageIE, "Contents");
    }

    protected void createFormContent(IManagedForm managedForm) {
        String description = null;
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Info Element Editor");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        form.setDelayedReflow(true);
        toolkit.decorateFormHeading(form.getForm());
        try {
            IConfigurationElement configElement = this.getConfigurationElementForIE(this.infoElement);
            this.editSection = this.createSection(form, toolkit, configElement, true);
            if (this.editSection != null) {
                this.editSection.setText("Edit contents");
                description = configElement.getAttribute("editDescription");
                this.editSection.setDescription(description != null ? description : GENERIC_EDIT_DESCRIPTION);
                this.editSection.setLayoutData((Object)new TableWrapData(256));
            }
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException(NLS.bind((String)"Unable to create editor viewer for {0}", (Object)this.infoElement.getClass().toString()), (Exception)e);
        }
        form.reflow(true);
    }

    @Override
    protected IIEDisplayViewer createViewer(Composite parent, ScrolledForm scrolledForm, FormToolkit toolkit, InfoElement infoElement, IConfigurationElement configElement) throws ClassNotFoundException {
        IIEEditViewer ieViewer = null;
        try {
            String viewerClassName = configElement.getAttribute("editViewer");
            if (viewerClassName == null) {
                throw new ClassNotFoundException();
            }
            Class<?> viewerClass = Class.forName(viewerClassName);
            Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class, Integer.TYPE);
            ieViewer = (IIEEditViewer)viewerConstructor.newInstance(parent, 0);
            IContentProvider contentProvider = (IContentProvider)configElement.createExecutableExtension("contentProvider");
            IBaseLabelProvider labelProvider = (IBaseLabelProvider)configElement.createExecutableExtension("labelProvider");
            ieViewer.setContentProvider(contentProvider);
            ieViewer.setLabelProvider(labelProvider);
            ieViewer.setPropertyModifier(new InfoElementPropertyModifier(this.getEditingDomain()));
            ieViewer.setInput(infoElement);
            if (ieViewer.getControl() instanceof Composite) {
                this.cascadeAdapt((Composite)ieViewer.getControl(), toolkit);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return ieViewer;
    }
}

