/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.ui.IPersistableElement;

public class CDOObjectEditorInput
extends PlatformObject
implements CDOEditorInput {
    private CDOView view;
    private boolean viewOwned;
    private String resourcePath;
    private String eObjectPath;

    public CDOObjectEditorInput(CDOView view, String resourcePath, String eObjectPath) {
        this(view, resourcePath, eObjectPath, false);
    }

    public CDOObjectEditorInput(CDOView view, String resourcePath, String eObjectPath, boolean viewOwned) {
        this.view = view;
        this.viewOwned = viewOwned;
        this.resourcePath = resourcePath;
        this.eObjectPath = eObjectPath;
    }

    public CDOView getView() {
        return this.view;
    }

    public boolean isViewOwned() {
        return this.viewOwned;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getEObjectPath() {
        return this.eObjectPath;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return CDOItemProvider.getViewImageDescriptor((CDOView)this.view);
    }

    public String getName() {
        if (this.resourcePath != null) {
            return new Path(this.resourcePath).lastSegment() != null ? new Path(this.resourcePath).lastSegment() : "";
        }
        return this.view.getSession().getRepositoryInfo().getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        long timeStamp;
        if (this.view.isClosed()) {
            return "";
        }
        CDOSession session = this.view.getSession();
        String repositoryName = session.getRepositoryInfo().getName();
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryName);
        if (this.resourcePath != null) {
            builder.append(this.resourcePath);
        }
        builder.append(" [");
        builder.append(session.getSessionID());
        builder.append(":");
        builder.append(this.view.getViewID());
        builder.append("]");
        if (this.view.isReadOnly()) {
            builder.append(" readonly");
        }
        if ((timeStamp = this.view.getTimeStamp()) != 0L) {
            builder.append(CDOCommonUtil.formatTimeStamp((long)timeStamp));
        }
        return builder.toString();
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.eObjectPath) ^ ObjectUtil.hashCode((Object)this.resourcePath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOObjectEditorInput) {
            CDOObjectEditorInput that = (CDOObjectEditorInput)((Object)obj);
            return ObjectUtil.equals((Object)this.resourcePath, (Object)that.resourcePath) && ObjectUtil.equals((Object)this.eObjectPath, (Object)that.eObjectPath);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.isViewOwned() && !this.view.isClosed()) {
            this.view.close();
        }
        super.finalize();
    }
}

