package es.upv.dsic.issi.dplfw.infoelement.singleeditor.preferences;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class SubjectsPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

	private final class SubjectsListEditor extends ListEditor {
		
		private SubjectsListEditor(String name, String labelText, Composite parent) {
			super(name, labelText, parent);
		}
		
		@Override
		protected String[] parseString(String stringList) {
			return stringList.trim().split(IESingleEditorPlugin.IESUBJECTS_SEPARATOR);
		}

		@Override
		protected String getNewInputObject() {
			InputDialog dialog = new InputDialog(getShell(),
					"New subject", "Enter a new subject:", "", new IInputValidator() {
						@Override
						public String isValid(String newText) {
							return StringUtils.isBlank(newText) ? "Subject cannot be empty" : null;
						}
					});
			if (dialog.open() == InputDialog.OK) {
				return dialog.getValue();
			}
			return null;
		}

		@Override
		public Composite getButtonBoxControl(Composite parent) {
			Composite buttonBoxControl = super.getButtonBoxControl(parent);
			if (buttonBoxControl.getLayout() instanceof GridLayout) {
				GridLayout layout = (GridLayout) buttonBoxControl.getLayout();
				layout.marginHeight = 0;
				layout.marginWidth = 0;
			}
			return buttonBoxControl;
		}
		
		@Override
		protected String createList(String[] items) {
			StringBuilder builder = new StringBuilder();
			for (String item : items) {	
				builder.append(item);
				builder.append(IESingleEditorPlugin.IESUBJECTS_SEPARATOR);
			}
			return builder.toString().trim();
		}
	}

	public SubjectsPreferencePage() {
		super(GRID);
		setPreferenceStore(IESingleEditorPlugin.getDefault().getPreferenceStore());
		setDescription("Subjects which can be associated to Info Elements");
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		SubjectsListEditor subjectFieldEditor = new SubjectsListEditor(PreferenceConstants.P_SUBJECTS, "Available &subjects:", getFieldEditorParent());
		List list = subjectFieldEditor.getListControl(getFieldEditorParent());
		GridData layoutData = new GridData();
		layoutData.grabExcessHorizontalSpace = true;
		layoutData.grabExcessVerticalSpace = true;
		layoutData.horizontalAlignment = SWT.FILL;
		layoutData.verticalAlignment = SWT.FILL;
		layoutData.minimumHeight = 200;
		layoutData.heightHint = 200;
		layoutData.minimumWidth = 400;
		list.setLayoutData(layoutData);
		addField(subjectFieldEditor);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
}