package es.upv.dsic.issi.dplfw.infoelement.singleeditor.preferences;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = IESingleEditorPlugin.getDefault().getPreferenceStore();

		// Load extension points which contribute default subjects
		IConfigurationElement[] configElts = Platform.getExtensionRegistry().getConfigurationElementsFor(
				IESingleEditorPlugin.IESUBJECT_EXT_POINT_ID);

		// Retrieve subjects from contributed ext. points
		// We use a SortedSet to avoid duplicates
		SortedSet<String> newDefaultSubjects = new TreeSet<String>();
		
		for (IConfigurationElement element : configElts) {
			for (IConfigurationElement subjectElement : element.getChildren(IESingleEditorPlugin.IESUBJECT_EXT_POINT_SUBJECT)) {
				newDefaultSubjects.add(
						// element.getAttribute(IESingleEditorPlugin.IESUBJECT_EXT_POINT_DOMAIN_NAME) + " - " + 
						subjectElement.getAttribute(IESingleEditorPlugin.IESUBJECT_EXT_POINT_SUBJECT_NAME).trim());
			}
		}
		
		
		// Store all registered subjects as defaults
		// and add newly added subjects to the current preference
		
		SortedSet<String> oldDefaultSubjects = new TreeSet<String>(
				Arrays.asList(store.getString(PreferenceConstants.P_SUBJECTS_OLD).split(IESingleEditorPlugin.IESUBJECTS_SEPARATOR)));
		
		StringBuilder newDefaultSubjectsBuilder = new StringBuilder();
		StringBuilder newSubjectsBuilder = new StringBuilder();
		for (String subject : newDefaultSubjects) {
			newDefaultSubjectsBuilder.append(subject);
			newDefaultSubjectsBuilder.append(IESingleEditorPlugin.IESUBJECTS_SEPARATOR);
			if (!oldDefaultSubjects.contains(subject)) {
				newSubjectsBuilder.append(subject);
				newSubjectsBuilder.append(IESingleEditorPlugin.IESUBJECTS_SEPARATOR);
			}
		}
		
		// Store new default subjects
		store.setValue(PreferenceConstants.P_SUBJECTS_OLD, newDefaultSubjectsBuilder.toString().trim());
		store.setDefault(PreferenceConstants.P_SUBJECTS, newDefaultSubjectsBuilder.toString().trim());

		// Update subjects with newly added default subjects
		String updatedSubjects = store.getString(PreferenceConstants.P_SUBJECTS) + IESingleEditorPlugin.IESUBJECTS_SEPARATOR + newSubjectsBuilder.toString().trim();
		store.setValue(PreferenceConstants.P_SUBJECTS, updatedSubjects);

	}
}
