package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.core.util.ZIPUtil;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextEditAbstractControl;


public class TextEditHtmlControl extends TextEditAbstractControl {

	private static final String EDITOR_FILENAME = "editor.html";
	
	private static final String CSS_FILENAME = "content.css";

	private static final String WORKING_DIRECTORY = "editor";

	private static final String RESOURCES_DIRECTORY = "resources";

	private static final String PLUGINS_SOURCE_DIRECTORY = RESOURCES_DIRECTORY + File.separator + "mce_plugins";

	private static final String PLUGINS_TARGET_DIRECTORY = "tinymce/jscripts/tiny_mce/plugins";

	private static final String TINYMCE_FILENAME = "tinymce_3.5.7.zip";

	private static final String LIPSUM_FILENAME = "loremipsum_0.1.2.zip";

	private static final String VARIABLES_FILENAME = "variables.zip";

	private static final String LIPSUM_ICON_PATH = "loremipsum/img";

	private static final String LIPSUM_ICON_FILENAME = "loremipsum.gif";

	
	private Browser browser;
	
	private String text;
	
	public TextEditHtmlControl(Composite parent, int style) {
		super(parent, style);
		setLayout(new TableWrapLayout());
		
		browser = new Browser(this, SWT.NONE);
		
		new FireModifyEventFunction(browser, "fireModifyEvent");
		new InitializeFunction(browser, "initializeContents");

		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB);
		layoutData.heightHint = 400;
		browser.setLayoutData(layoutData);
		
		
		try {
			File directory = IESingleEditorPlugin.getDefault().getBundle().getDataFile(WORKING_DIRECTORY);
			prepareOnDir(directory);
			browser.setUrl(directory.getAbsolutePath() + File.separator + EDITOR_FILENAME);
			browser.setJavascriptEnabled(true);
			
			
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	
	private void prepareOnDir(File directory) throws IOException {
		
		// Extract tinyMCE
		InputStream tinyMCEStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(RESOURCES_DIRECTORY + File.separator + TINYMCE_FILENAME),
				false);
		
		ZIPUtil.unzip(tinyMCEStream, directory, false);

		// Extract the Lorem Ipsum plugin
		InputStream lipsumStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(PLUGINS_SOURCE_DIRECTORY + File.separator + LIPSUM_FILENAME),
				false);
		
		ZIPUtil.unzip(lipsumStream, new File(directory.getAbsolutePath() + File.separator + PLUGINS_TARGET_DIRECTORY), false);
		
		// Extract the Variables plugin
		InputStream variablesStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(PLUGINS_SOURCE_DIRECTORY + File.separator + VARIABLES_FILENAME),
				false);
		
		ZIPUtil.unzip(variablesStream, new File(directory.getAbsolutePath() + File.separator + PLUGINS_TARGET_DIRECTORY), false);
		
		
		// Copy the HTML file of the editor
		InputStream editorStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(RESOURCES_DIRECTORY + File.separator + EDITOR_FILENAME),
				false);

		FileUtils.copyInputStreamToFile(editorStream, 
				new File(directory + File.separator + EDITOR_FILENAME));

		// Copy the custom CSS to override the TinyMCE style
		InputStream cssStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(RESOURCES_DIRECTORY + File.separator + CSS_FILENAME),
				false);
		
		FileUtils.copyInputStreamToFile(cssStream, 
				new File(directory + File.separator + CSS_FILENAME));
		
		// Substitute the Lorem Ipsum icon
		InputStream lipsumIconStream = FileLocator.openStream(
				IESingleEditorPlugin.getDefault().getBundle(),
				new Path(RESOURCES_DIRECTORY + File.separator + LIPSUM_ICON_FILENAME),
				false);
		
		FileUtils.copyInputStreamToFile(lipsumIconStream, 
				new File(new File(directory.getAbsolutePath() + File.separator + PLUGINS_TARGET_DIRECTORY
						+ File.separator + LIPSUM_ICON_PATH) + File.separator + LIPSUM_ICON_FILENAME));
		
	}

	protected void fireModifyEvent() {
		getDisplay().syncExec(new Runnable() {
			@Override
			public void run() {
				if (!isDisposed()) {
					notifyListeners(SWT.Modify, new Event());
				}
			}
		});		
	}

	public Browser getBrowserControl() {
		return browser;
	}

	@Override
	public void setText(String textMessage) {
		this.text = textMessage;
	}

	@Override
	public String getText() {
		return this.text;
	}
	
	
	/*
	 * Browser Functions
	 * 
	 * They are called from the 
	 */
	
	private class FireModifyEventFunction extends BrowserFunction {

		public FireModifyEventFunction(Browser browser, String name) {
			super(browser, name);
		}
		
		@Override
		public Object function(Object[] arguments) {
			browser.execute(String.format("tinyMCE.activeEditor.variables = "+getVariablesString()+";"));
			Object contents = browser.evaluate("return tinyMCE.activeEditor.getContent({format : 'raw'});");
			if (contents instanceof String) {
				text = (String) contents;
				fireModifyEvent();
			}
			return null;
		}
		
	}
	
	private class InitializeFunction extends BrowserFunction {
		
		public InitializeFunction(Browser browser, String name) {
			super(browser, name);
		}
		
		@Override
		public Object function(Object[] arguments) {
			browser.execute(String.format("tinyMCE.activeEditor.variables = "+getVariablesString()+";"));
			browser.execute(String.format("tinyMCE.activeEditor.setContent('%s',{format : 'raw'});", text));
			browser.execute("resizeEditorToFillSpace();");
			return null;
		}
		
	}
	
	public String getVariablesString(){
		
		StringBuffer vars = new StringBuffer();
		Iterator iter = variables.iterator();
		vars.append('[');
		 while (iter.hasNext()) {
			 vars.append("'"+iter.next()+"'");
		      if (iter.hasNext()) {
		    	  vars.append(',');
		      }
		 }
		 vars.append(']');
		return vars.toString();
	}

}
