package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.html;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextDisplayAbstractControl;



public class TextDisplayHtmlControl extends TextDisplayAbstractControl {

	private Browser browser;
	private String jsHeight = 
			  "var D = document;"
			+ "  return Math.max("
			+ "      Math.max(D.body.scrollHeight, D.documentElement.scrollHeight),"
			+ "      Math.max(D.body.offsetHeight, D.documentElement.offsetHeight),"
			+ "      Math.max(D.body.clientHeight, D.documentElement.clientHeight)"
			+ "   );";
	
	private String jsWidth = 
			  "var D = document;"
			+ "  return Math.max("
			+ "      Math.max(D.body.scrollWidth, D.documentElement.scrollWidth),"
			+ "      Math.max(D.body.offsetWidth, D.documentElement.offsetWidth),"
			+ "      Math.max(D.body.clientWidth, D.documentElement.clientWidth)"
			+ "   );";
	
	private TableWrapData layoutData;
	
	public TextDisplayHtmlControl(Composite parent, int style) {
		super(parent, style);
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = 20;
		layout.rightMargin = 20;
		layout.topMargin = 20;
		layout.bottomMargin = 20;
		setLayout(layout);

		browser = new Browser(this, SWT.WRAP | SWT.MULTI);
		layoutData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB);
		browser.setLayoutData(layoutData);
		
		new BrowserFunction(browser, "refresh") {
			@Override
			public Object function(Object[] arguments) {
				updateHeight();
				notifyListeners(SWT.Resize, new Event());
            	return null;
			}
		};
		
		addListener(SWT.Resize, new Listener() {
			@Override
			public void handleEvent(Event event) {
				updateHeight();
			}
		});
	}

	public void refresh() {
		browser.setText(buildFormContent(), true);
		browser.addProgressListener(new ProgressListener() {
            @Override
            public void completed(ProgressEvent event) {
            	updateHeight();
            	notifyListeners(SWT.Resize, new Event());
            }
            @Override
            public void changed(ProgressEvent event) {
            }
        });
	}

	private void updateHeight() {
		try {
			int height = 300;
	    	Object objHeight = browser.evaluate(jsHeight);
	    	if (objHeight != null && objHeight instanceof Double) {
	    		height = ((Double) objHeight).intValue();
	    	}
	    	layoutData.heightHint = height;
			layout(true, true);
		} catch (SWTException e) {
		}
	}

	
	private String buildFormContent() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("<html>");
		stringBuilder.append("<head>");
		stringBuilder.append("<style type=\"text/css\">");
		stringBuilder.append("  body {");
//		stringBuilder.append("    overflow-x: hidden;");
		stringBuilder.append("    overflow-y: hidden;");
		stringBuilder.append("  }");
		stringBuilder.append("</style>");
		stringBuilder.append("</head>");
		stringBuilder.append("<body onload='window.onresize = refresh();'>");
		if (StringUtils.isNotBlank(title)) {
			stringBuilder.append("<H1>");
			stringBuilder.append(title);
			stringBuilder.append("</H1>");
		}
		if (StringUtils.isNotEmpty(text)) {
			stringBuilder.append(text);
		}
		stringBuilder.append("</body>");
		stringBuilder.append("</html>");
		return stringBuilder.toString();
	}
}
