package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.basic;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextEditAbstractControl;


public class TextEditBasicControl extends TextEditAbstractControl {

	private Text text;
	
	public TextEditBasicControl(Composite parent, int style) {
		super(parent, style);
		setLayout(new TableWrapLayout());

		text = new Text(this, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL | SWT.WRAP | SWT.BORDER);
		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB);
		layoutData.heightHint = 350;
		text.setLayoutData(layoutData);
		text.addListener(SWT.Modify, new Listener() {
			@Override
			public void handleEvent(Event event) {
				notifyListeners(SWT.Modify, event);
			}
		});
	}
	
	public Text getTextControl() {
		return text;
	}

	@Override
	public void setText(String textMessage) {
		text.setText(textMessage != null ? textMessage : "");
	}

	@Override
	public String getText() {
		return text.getText();
	}
}
