package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.basic;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextDisplayAbstractControl;



public class TextDisplayFormControl extends TextDisplayAbstractControl {
	
	protected FormText formText;
	
	public TextDisplayFormControl(Composite parent, int style) {
		super(parent, style);
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = 20;
		layout.rightMargin = 20;
		layout.topMargin = 20;
		layout.bottomMargin = 20;
		setLayout(layout);

		formText = new FormText(this, SWT.WRAP | SWT.MULTI);
		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB);
		formText.setLayoutData(layoutData);

	}

	public void refresh() {
		formText.setFont(SWTUtil.getDefaultTextFont());
		formText.setFont("TITLE", SWTUtil.getDefaultTitleFont());
		formText.setText(buildFormContent(), true, false);
		notifyListeners(SWT.Resize, new Event());
	}

	
	String buildFormContent() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("<form>");
		if (StringUtils.isNotBlank(title)) {
			stringBuilder.append("<p><span font=\"TITLE\">");
			stringBuilder.append(title);
			stringBuilder.append("</span></p><p></p>");
		}
		String[] paragraphs = text.split("\n");
		for (String paragraph : paragraphs) {
			if (StringUtils.isNotEmpty(paragraph)) {
			stringBuilder.append("<p>");
			stringBuilder.append(paragraph);
			stringBuilder.append("</p>");
			}
		}
		stringBuilder.append("</form>");
		return stringBuilder.toString();
	}
}
