package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.basic;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text.TextDisplayAbstractControl;


public class TextDisplayBasicControl extends TextDisplayAbstractControl {
	
	protected Text textControl;
	
	public TextDisplayBasicControl(Composite parent, int style) {
		super(parent, style);
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = 20;
		layout.rightMargin = 20;
		layout.topMargin = 20;
		layout.bottomMargin = 20;
		setLayout(layout);

		textControl = new Text(this, SWT.WRAP | SWT.MULTI);
		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB);
		textControl.setLayoutData(layoutData);

	}

	public void refresh() {
		textControl.setFont(SWTUtil.getDefaultTextFont());
		textControl.setText(buildFormContent());
		notifyListeners(SWT.Resize, new Event());
	}

	
	String buildFormContent() {
		StringBuilder stringBuilder = new StringBuilder();
		if (StringUtils.isNotBlank(title)) {
			stringBuilder.append(title);
		}
		if (StringUtils.isNotEmpty(text)) {
			stringBuilder.append(text);
		}
		return stringBuilder.toString();
	}
}
