package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;

public abstract class TextEditAbstractViewer extends InfoElementAbstractEditViewer {

	protected TextEditAbstractControl control;
	private Runnable saveChangesDelayed = new Runnable() {
		
		@Override
		public void run() {
			IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
			ITextLabelProvider labelProvider = (ITextLabelProvider) getLabelProvider();

			InfoElement element = contentProvider.getElement(getInput());
			
			if (element != null && labelProvider.getText(element) != null) {
				boolean update = false;
				if (labelProvider.getText(element).length() != control.getText().length()) {
					// Different length -> update
					update = true;
				} else if (labelProvider.getText(element).length() > 4096) {
					// Very long String -> let's avoid the comparison & update
					update = true;
				} else if (!labelProvider.getText(element).equals(control.getText())) {
					// Different strings -> update
					update = true;
				}
				if (update) {
					getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.TEXT_IE__CONTENTS, control.getText());
				}
			}			
		}
	};
	
	public TextEditAbstractViewer(TextEditAbstractControl textIEComposite) {
		control = textIEComposite;
		control.addListener(SWT.Modify, new Listener() {
			
			@Override
			public void handleEvent(Event event) {
				Display.getDefault().timerExec(800, saveChangesDelayed);
			}
		});
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ITextLabelProvider labelProvider = (ITextLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());

		if (element != null) {
			String text = labelProvider.getText(element);
			if (!control.isDisposed() && !text.equals(control.getText())) {
				control.setText(text);
				control.addVariables(element.getVariables());
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ITextLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(getPropertyModifier() != null,
				"TextViewer must have a property modifier when input is set."); //$NON-NLS-1$
		Assert.isTrue(input instanceof TextIE,
				"Input of TextViewer must be of TextIE type."); //$NON-NLS-1$
	    
		super.setInput(input);
	}

	
}
