package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;

public abstract class TextDisplayAbstractViewer extends InfoElementAbstractDisplayViewer {

	
	private TextDisplayAbstractControl control;
	

	public TextDisplayAbstractViewer(TextDisplayAbstractControl textDisplayControl) {
		control = textDisplayControl;
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ITextLabelProvider labelProvider = (ITextLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());

		if (element != null) {
			String text = labelProvider.getText(element);
			if (!control.isDisposed()) {
				control.setTitle(element.getTitle());
				control.setText(text);
				control.refresh();
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ITextLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(input instanceof TextIE,
				"Input of TextViewer must be of TextIE type."); //$NON-NLS-1$
	    
		super.setInput(input);

		TextIE textIE = (TextIE) input;
		textIE.eAdapters().add(new AdapterImpl() {
			@Override
			public void notifyChanged(Notification msg) {
				if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getTextIE_Contents()) {
					control.setText(msg.getNewStringValue());
					control.refresh();
				} else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title()) {
					control.setTitle(msg.getNewStringValue());
					control.refresh();
				}
			}
		});
	}
}
