package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.eclipse.jface.viewers.BaseLabelProvider;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.LocationIE;
import es.upv.dsic.issi.dplfw.infoelements.MapType;

public class LocationIELabelProvider extends BaseLabelProvider implements ILocationLabelProvider {

	public byte[] getImageBytes(Object element) {
		if (element instanceof ImageIE && ((ImageIE) element).getContents() != null) {
			return ((ImageIE) element).getContents();
		} else {
			try {
				return IOUtils.toByteArray(getClass().getResourceAsStream(
						IESingleEditorPlugin.PATH_IMAGE_NO_IMAGE));
			} catch (IOException e) {
				e.printStackTrace();
			}
			return null;
		}
	}

	public int getWidth(Object element) {
		if (element instanceof ImageIE) {
			return ((ImageIE)element).getDisplayWidth();
		} else {
			return 0;
		}
	}

	public int getHeight(Object element) {
		if (element instanceof ImageIE) {
			return ((ImageIE)element).getDisplayHeight();
		} else {
			return 0;
		}
	}

	@Override
	public float getLatitude(Object element) {
		if (element instanceof LocationIE) {
			return ((LocationIE)element).getLatitude();
		} else {
			return 0;
		}
	}

	@Override
	public float getLongitude(Object element) {
		if (element instanceof LocationIE) {
			return ((LocationIE)element).getLongitude();
		} else {
			return 0;
		}
	}

	@Override
	public int getZoom(Object element) {
		if (element instanceof LocationIE && 
				((LocationIE) element).getPreview() != null) {
			return ((LocationIE)element).getPreview().getZoom();
		} else {
			return 0;
		}
	}

	@Override
	public MapType getMapType(Object element) {
		if (element instanceof LocationIE && 
				((LocationIE) element).getPreview() != null) {
			return ((LocationIE)element).getPreview().getType();
		} else {
			return null;
		}
	}

	@Override
	public byte[] getPreviewBytes(Object element) {
		if (element instanceof LocationIE && 
				((LocationIE) element).getPreview() != null &&
				((LocationIE) element).getPreview().getContents() != null) {
			return ((LocationIE) element).getPreview().getContents();
		} else {
			try {
				return IOUtils.toByteArray(getClass().getResourceAsStream(
						IESingleEditorPlugin.PATH_IMAGE_NO_IMAGE));
			} catch (IOException e) {
				e.printStackTrace();
			}
			return null;
		}
	}

	

}
