package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.LocationIE;
import es.upv.dsic.issi.dplfw.infoelements.MapType;

public class LocationEditViewer extends InfoElementAbstractEditViewer {

	
	LocationEditControl control;
		
	public LocationEditViewer(Composite parent) {
		this(parent, SWT.NONE);
	}

	public LocationEditViewer(Composite parent, int style) {
		this(new LocationEditControl(parent, style));
	}
	
	public LocationEditViewer(LocationEditControl locationIEComposite) {
		control = locationIEComposite;
		for (MapType type : MapType.values()) {
			control.getMapTypeCombo().add(type.getName());
		}
		addListeners();
	}

	private void addListeners() {
		control.getLatitudeSpinner().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				float value = getFloatValueFromSpinner((Spinner) e.getSource());
				getPropertyModifier().setValue(getInput(), InfoelementsPackage.LOCATION_IE__LATITUDE, value);
			}
		});
		control.getLatitudeSpinner().addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				float value = getFloatValueFromSpinner((Spinner) e.getSource());
				getPropertyModifier().setValue(getInput(), InfoelementsPackage.LOCATION_IE__LATITUDE, value);
			}
		});
		control.getLongitudeSpinner().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				float value = getFloatValueFromSpinner((Spinner) e.getSource());
				getPropertyModifier().setValue(getInput(), InfoelementsPackage.LOCATION_IE__LONGITUDE, value);
			}
		});
		control.getLongitudeSpinner().addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				float value = getFloatValueFromSpinner((Spinner) e.getSource());
				getPropertyModifier().setValue(getInput(), InfoelementsPackage.LOCATION_IE__LONGITUDE, value);
			}
		});
		control.getZoomSpinner().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				checkLocationPreview((LocationIE) getInput());
				getPropertyModifier().setValue(((LocationIE)getInput()).getPreview(), 
						InfoelementsPackage.LOCATION_MAP_PREVIEW_IE__ZOOM, 
						((Spinner) e.getSource()).getSelection());
			}
		});
		control.getZoomSpinner().addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				checkLocationPreview((LocationIE) getInput());
				getPropertyModifier().setValue(((LocationIE)getInput()).getPreview(), 
						InfoelementsPackage.LOCATION_MAP_PREVIEW_IE__ZOOM, 
						((Spinner) e.getSource()).getSelection());
			}
		});
		control.getMapTypeCombo().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				checkLocationPreview((LocationIE) getInput());
				getPropertyModifier().setValue(((LocationIE)getInput()).getPreview(), 
						InfoelementsPackage.LOCATION_MAP_PREVIEW_IE__TYPE, 
						((Combo) e.getSource()).getSelection());
			}
		});
	}
	
	private static void checkLocationPreview(LocationIE input) {
		if (input.getPreview() == null)
			input.setPreview(InfoelementsFactory.eINSTANCE.createLocationMapPreviewIE());
	}

	
	private static float getFloatValueFromSpinner(Spinner spinner) {
		float value = (float) spinner.getSelection() / (float) Math.pow(10, spinner.getDigits());
		return value;
	}

	private static void setFloatValueToSpinner(Spinner spinner, float value) {
		spinner.setSelection((int) (value * Math.pow(10, spinner.getDigits())));
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ILocationLabelProvider labelProvider = (ILocationLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());
		
		if (element != null) {
			float lat = labelProvider.getLatitude(element);
			float lon = labelProvider.getLatitude(element);
			int zoom = labelProvider.getZoom(element);
			MapType type = labelProvider.getMapType(element);
			byte[] bytes = labelProvider.getPreviewBytes(element);
			if (!control.isDisposed()) {
				setFloatValueToSpinner(control.getLongitudeSpinner(), lat);
				setFloatValueToSpinner(control.getLatitudeSpinner(), lon);
				control.getZoomSpinner().setSelection(zoom);
				control.getMapTypeCombo().setText(type != null ? type.getName() : "");
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	
	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ILocationLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(getPropertyModifier() != null,
				"LocationEditViewer must have a property modifier when input is set."); //$NON-NLS-1$
		super.setInput(input);
		
		Assert.isTrue(input instanceof LocationIE,
				"Input of LocationEditViewer must be of LocationIE type."); //$NON-NLS-1$
	    
//		ImageIE imageIE = (ImageIE) input;
//		imageIE.eAdapters().add(new AdapterImpl() {
//			@Override
//			public void notifyChanged(Notification msg) {
//				if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIEContents_Contents()) {
//					Display.getDefault().asyncExec(new Runnable() {
//						public void run() {
//							refresh();
//						}
//					});
//				}
//			}
//		});
	}
}
