package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import java.util.Locale;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;


public class LocationEditControl extends Composite {


	private Composite browserComposite;
	private Composite editComposite;

	private Spinner latitudeSpinner;
	private Spinner longitudeSpinner;
	private Spinner zoomSpinner;
	private Combo mapTypeCombo;
	private Browser browser;
	
	public LocationEditControl(Composite parent, int style) {
		super(parent, style);
		
		setLayout(new TableWrapLayout());

		editComposite = new Composite(this, SWT.NONE);
		TableWrapLayout tableWrapLayout = new TableWrapLayout();
		tableWrapLayout.numColumns = 2;
		tableWrapLayout.makeColumnsEqualWidth = false;
		editComposite.setLayout(tableWrapLayout);
		editComposite.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		
		{ // Image composite. Fill horizontal.
			browserComposite = new Composite(editComposite, SWT.BORDER | SWT.FLAT);
			browserComposite.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
			
			TableWrapLayout browserCompositeLayout = new TableWrapLayout();
			
			browserComposite.setLayout(browserCompositeLayout);
			browser = new Browser(browserComposite, SWT.NONE);
			TableWrapData browserLayoutData = new TableWrapData(TableWrapData.FILL_GRAB);
			browserLayoutData.maxWidth = 0;
			browserLayoutData.heightHint = 480;
			browser.setLayoutData(browserLayoutData);
			browser.setText(getInitialBrowserContents(), true);
	        browser.addProgressListener(new ProgressListener() {
	            @Override
	            public void completed(ProgressEvent event) {
	                browser.execute("initiate_geolocation();");
	            }
	            @Override
	            public void changed(ProgressEvent event) {
	            }
	        });
		}
		{ // Details composite. Row layout.
			{
				Composite attribsComposite = new Composite(editComposite, SWT.NONE);
				TableWrapLayout sizesCompositeLayout = new TableWrapLayout();
				sizesCompositeLayout.numColumns = 2;
				sizesCompositeLayout.makeColumnsEqualWidth = false;
				sizesCompositeLayout.horizontalSpacing = 10;
				attribsComposite.setLayout(sizesCompositeLayout);

				Label latitudeLabel = new Label(attribsComposite, SWT.NONE);
				latitudeLabel.setText("Latitude:");
				
				latitudeSpinner = new Spinner(attribsComposite, SWT.SINGLE | SWT.BORDER);
				latitudeSpinner.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
				latitudeSpinner.setDigits(6);
				latitudeSpinner.setMaximum(90000000);
				latitudeSpinner.setMinimum(-90000000);
				latitudeSpinner.setIncrement(1000);
				

				Label longitudeLabel = new Label(attribsComposite, SWT.NONE);
				longitudeLabel.setText("Latitude:");
				
				longitudeSpinner = new Spinner(attribsComposite, SWT.SINGLE | SWT.BORDER);
				longitudeSpinner.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
				longitudeSpinner.setDigits(6);
				longitudeSpinner.setMaximum(180000000);
				longitudeSpinner.setMinimum(-180000000);
				longitudeSpinner.setIncrement(1000);

				Label zoomLabel = new Label(attribsComposite, SWT.NONE);
				zoomLabel.setText("Zoom:");
				
				zoomSpinner = new Spinner(attribsComposite, SWT.BORDER);
				zoomSpinner.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
				zoomSpinner.setMinimum(0);
				zoomSpinner.setMaximum(20);
				zoomSpinner.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));

				Label mapTypeLabel = new Label(attribsComposite, SWT.NONE);
				mapTypeLabel.setText("Map type:");

				mapTypeCombo = new Combo(attribsComposite, SWT.READ_ONLY | SWT.BORDER | SWT.FLAT | SWT.DROP_DOWN);
				mapTypeCombo.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));

			}
		}
		
		addListener(SWT.Resize, new Listener() {
			@Override
			public void handleEvent(Event event) {
			}
		});
		
		layout(true, true);
	}
	
	
	private String getInitialBrowserContents() {
		StringBuilder builder = new StringBuilder();
		builder.append("<html>");
		builder.append("  <head>");
		builder.append("	<script>");

		builder.append("		function initiate_geolocation() {");
		builder.append("			if (navigator.geolocation) {");
		builder.append("				navigator.geolocation.getCurrentPosition(handle_geolocation_query);");
		builder.append("			} else {");
		builder.append("				var image_url = \"http://maps.google.com/maps?q=" + Locale.getDefault().getDisplayCountry() + "&output=embed&t=k\";");
		builder.append("				window.location.href=image_url;");
		builder.append("			}");
		builder.append("		}");
		
		builder.append("		function handle_geolocation_query(position)");
		builder.append("		{  ");
		builder.append("			var image_url = \"http://maps.google.com/maps?ll=\" + position.coords.latitude + \",\" +");
		builder.append("							position.coords.longitude + \"&output=embed&t=k&iwloc=near\";");
		builder.append("			window.location.href=image_url;");
		builder.append("		}");
		
		builder.append("		</script>");
		builder.append("	</head>");
		builder.append("	<body>");
		builder.append("	</body>");
		builder.append("</html>");
		return builder.toString();
	}


	/**
	 * @return the latitudeSpinner
	 */
	public Spinner getLatitudeSpinner() {
		return latitudeSpinner;
	}

	/**
	 * @return the longitudeSpinner
	 */

	public Spinner getLongitudeSpinner() {
		return longitudeSpinner;
	}


	/**
	 * @return the zoomSpinner
	 */
	public Spinner getZoomSpinner() {
		return zoomSpinner;
	}


	/**
	 * @return the mapTypeCombo
	 */
	public Combo getMapTypeCombo() {
		return mapTypeCombo;
	}


	public void refresh() {
	}
}
