package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;

public class LocationDisplayViewer extends InfoElementAbstractDisplayViewer {

	
	LocationDisplayControl control;
	
	public LocationDisplayViewer(Composite parent, int style) {
		this(new LocationDisplayControl(parent, style));
	}
	
	public LocationDisplayViewer(Composite parent) {
		this(parent, SWT.NONE);
	}
	
	public LocationDisplayViewer(LocationDisplayControl imageIEComposite) {
		control = imageIEComposite;
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ILocationLabelProvider labelProvider = (ILocationLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());
		
//		if (element != null) {
//			byte[] bytes = labelProvider.getImageBytes(element);
//			int width = labelProvider.getWidth(element);
//			int height = labelProvider.getHeight(element);
//			if (!control.isDisposed()) {
//				control.setImageBytes(bytes);
//				control.setWidth(width);
//				control.setHeight(height);
//				control.setTitle(element.getTitle());
//				control.setDescription(element.getDescription());
//				control.refresh();
//			}
//		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	
	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ILocationLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		super.setInput(input);
		
		Assert.isTrue(input instanceof ImageIE,
				"Input of SizedImageViewer must be of ImageIE type."); //$NON-NLS-1$
	    
		ImageIE imageIE = (ImageIE) input;
		
		imageIE.eAdapters().add(new AdapterImpl() {
			private Runnable runnable = new Runnable() {
				public void run() {
					if (!control.isDisposed()) {
						control.refresh();
					}
				}
			};
			@Override
			public void notifyChanged(Notification msg) {
				if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIEContents_Contents()) {
					control.setImageBytes((byte[]) msg.getNewValue());
					Display.getDefault().asyncExec(runnable);
				} else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIE_DisplayHeight()) {
					control.setHeight((Integer) msg.getNewValue());
					Display.getDefault().asyncExec(runnable);
				} else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getImageIE_DisplayWidth()) {
					control.setWidth((Integer) msg.getNewValue());
					Display.getDefault().asyncExec(runnable);
				} else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title()) {
					control.setTitle(msg.getNewStringValue());
					Display.getDefault().asyncExec(runnable);
				} else if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Description()) {
					control.setDescription(msg.getNewStringValue());
					Display.getDefault().asyncExec(runnable);
				}
			}
		});
	}
}
