package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.location;

import java.io.ByteArrayInputStream;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;


public class LocationDisplayControl extends Composite {

	private static final int MARGIN_SIZE = 20;
	private Composite imageComposite;
	private Label imageLabel;
	private Image image;
	private FormText formText;
	private int width;
	private int height;
	private String title;
	private String description;
	
	public LocationDisplayControl(Composite parent, int style) {

		super(parent, style);
		
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = MARGIN_SIZE;
		layout.rightMargin = MARGIN_SIZE;
		layout.topMargin = MARGIN_SIZE;
		layout.bottomMargin = MARGIN_SIZE;
		setLayout(layout);

		formText = new FormText(this, SWT.WRAP | SWT.MULTI);
		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB);
		formText.setLayoutData(layoutData);

		{ // Image composite. Fill horizontal.
			imageComposite = new Composite(this, SWT.NONE);
			imageComposite.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
			imageComposite.setLayout(new TableWrapLayout());
			
			Composite dummy = new Composite(imageComposite, SWT.NONE);
			dummy.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
			GridLayout gridLayout = new GridLayout();
			gridLayout.marginWidth = 0;
			gridLayout.marginHeight = 0;
			gridLayout.verticalSpacing = 0;
			dummy.setLayout(gridLayout);
			
			imageLabel = new Label(imageComposite, SWT.NONE);
			imageLabel.setLayoutData(new TableWrapData(TableWrapData.CENTER));

		}
		createDisposeListener();

	}
	
	public void setImageBytes(byte[] bytes) {
		if (this.image != null)
			this.image.dispose();
		this.image = new Image(getDisplay(), new ByteArrayInputStream(bytes));
		refresh();
	}

	public void setWidth(int width) {
		this.width = width;
		refresh();
	}
	
	public void setHeight(int height) {
		this.height = height;
		refresh();
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public synchronized void refresh() {
		replaceImage(SWTUtil.createResizedImage(image, Math.max(width, 1), Math.max(height, 1)));
		formText.setFont(SWTUtil.getDefaultTextFont());
		formText.setFont("TITLE", SWTUtil.getDefaultTitleFont());
		formText.setText(buildFormContent(), true, false);
	}

	private String buildFormContent() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("<form>");
		if (StringUtils.isNotBlank(title)) {
			stringBuilder.append("<p><span font=\"TITLE\">");
			stringBuilder.append(title);
			stringBuilder.append("</span></p><p></p>");
		}
		if (StringUtils.isNotBlank(description)) {
			stringBuilder.append("<p>");
			stringBuilder.append(description);
			stringBuilder.append("</p>");
		}
		stringBuilder.append("</form>");
		return stringBuilder.toString();
	}

	private synchronized void replaceImage(Image image) {
		if (imageLabel != null) { 
			if (imageLabel.getImage() != null) {
			imageLabel.getImage().dispose();
			}
			imageLabel.setImage(image);
			imageLabel.setSize(imageLabel.computeSize(SWT.DEFAULT, SWT.DEFAULT));
			setSize(computeSize(imageComposite.getSize().x + MARGIN_SIZE * 2, SWT.DEFAULT));
			layout(true, true);
		}
	}
	
	private void createDisposeListener() {
		this.addDisposeListener(new DisposeListener() {
			@Override
			public void widgetDisposed(DisposeEvent e) {
				if (image != null) {
					image.dispose();
				}
				if (imageLabel != null && imageLabel.getImage() != null) {
					imageLabel.getImage().dispose();
				}
			}
		});
	}

}
