package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.LinkIE;

public class LinkEditViewer extends InfoElementAbstractEditViewer {

	
	private LinkEditControl control;
	
	public LinkEditViewer(Composite parent) {
		this(parent, SWT.NONE);
	}
	
	public LinkEditViewer(Composite parent, int style) {
		this(new LinkEditControl(parent, style));
	}
	
	public LinkEditViewer(LinkEditControl linkIEComposite) {
		control = linkIEComposite;
		control.getTextControl().addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
				ILinkLabelProvider labelProvider = (ILinkLabelProvider) getLabelProvider();

				InfoElement element = contentProvider.getElement(getInput());
				
				if (element != null && labelProvider.getLink(element) != null &&
						!labelProvider.getLink(element).equals(control.getLink())) {
					getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.LINK_IE__CONTENTS, control.getLink());
				}
			}
		});
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ILinkLabelProvider labelProvider = (ILinkLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());

		if (element != null) {
			String text = labelProvider.getLink(element);
			if (!control.isDisposed() && !text.equals(control.getLink())) {
				control.setLink(text);
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}
	
	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ILinkLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(getPropertyModifier() != null,
				"LinkViewer must have a property modifier when input is set."); //$NON-NLS-1$
		super.setInput(input);
		
		Assert.isTrue(input instanceof LinkIE,
				"Input of LinkViewer must be of LinkIE type."); //$NON-NLS-1$
	}
}
