package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.LinkIE;

public class LinkDisplayViewer extends InfoElementAbstractDisplayViewer {

	
	private LinkDisplayControl control;
	
	public LinkDisplayViewer(Composite parent) {
		this(parent, SWT.NONE);
	}
	
	public LinkDisplayViewer(LinkDisplayControl linkDisplayControl) {
		control = linkDisplayControl;
	}

	public LinkDisplayViewer(Composite parent, int style) {
		this(new LinkDisplayControl(parent, style));
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ILinkLabelProvider labelProvider = (ILinkLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());

		if (element != null) {
			String text = labelProvider.getLink(element);
			if (!control.isDisposed()) {
				control.setTitle(element.getTitle());
				control.setLink(text);
				control.refresh();
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ILinkLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(input instanceof LinkIE,
				"Input of TextViewer must be of LinkIE type."); //$NON-NLS-1$
	    
		super.setInput(input);

		LinkIE linkIE = (LinkIE) input;
		linkIE.eAdapters().add(new AdapterImpl() {
			@Override
			public void notifyChanged(Notification msg) {
				if (control.isVisible()) {
					if (msg.getFeature() == InfoelementsPackage.eINSTANCE.getLinkIE_Contents() ||
							msg.getFeature() == InfoelementsPackage.eINSTANCE.getInfoElement_Title()) {
						Display.getDefault().asyncExec(new Runnable() {
							public void run() {
								refresh();
							}
						});
					}
				}
			}
		});
	}

	
}
