package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.link;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.statushandlers.StatusManager;

import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;


public class LinkDisplayControl extends Composite {

	private FormText formText;
	private String title;
	private String link;
	
	public LinkDisplayControl(Composite parent, int style) {
		super(parent, style);
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = 20;
		layout.rightMargin = 20;
		layout.topMargin = 20;
		layout.bottomMargin = 20;
		setLayout(layout);

		formText = new FormText(this, SWT.WRAP | SWT.MULTI);
		formText.addHyperlinkListener(new HyperlinkAdapter() {
			@Override
			public void linkActivated(HyperlinkEvent e) {
				openLink();
			}
		});

		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB);
		formText.setLayoutData(layoutData);
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public void setLink(String link) {
		this.link = link;
	}
	
	public void refresh() {
		formText.setFont("TITLE", SWTUtil.getDefaultTitleFont());
		formText.setFont(SWTUtil.getDefaultTextFont());
		formText.setText(buildFormContent(), true, false);
	}

	protected void openLink() {
		try {
			URI uri = new URI(link);
			if (StringUtils.equals(uri.getScheme(), "http") || StringUtils.equals(uri.getScheme(), "https")) {
				PlatformUI.getWorkbench().getBrowserSupport().createBrowser(IESingleEditorPlugin.PLUGIN_ID).openURL(uri.toURL());
			} else {
				boolean open = MessageDialog.openQuestion(getShell(), "Open URI?", 
						String.format("The editor is attempting to open the location '%s' " +
								"with your system's default application. " +
								"Opening untrusted locations is potentially dangerous. " +
								"Are you sure you want to continue?", link));
				if (open)
					Program.launch(link);
			}
		} catch (PartInitException e) {
			e.printStackTrace();
		} catch (URISyntaxException e) {
			StatusManager.getManager().handle(
					new Status(Status.ERROR, IESingleEditorPlugin.PLUGIN_ID, e.getLocalizedMessage(), e),
					StatusManager.BLOCK | StatusManager.LOG);
		} catch (MalformedURLException e) {
			StatusManager.getManager().handle(
					new Status(Status.ERROR, IESingleEditorPlugin.PLUGIN_ID, e.getLocalizedMessage(), e),
					StatusManager.BLOCK | StatusManager.LOG);
		} 
	}

	private String buildFormContent() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("<form>");
		if (StringUtils.isNotBlank(title)) {
			stringBuilder.append("<p><span font=\"TITLE\">");
			stringBuilder.append(title);
			stringBuilder.append("</span></p><p></p>");
		}
		if (StringUtils.isNotBlank(link)) {
			stringBuilder.append("<p><a href=\"");
			stringBuilder.append(link);
			stringBuilder.append("\">");
			stringBuilder.append(title);
			stringBuilder.append("</a></p>");
		}
		stringBuilder.append("</form>");
		return stringBuilder.toString();
	}

}
