package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementAbstractEditViewer;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;
import es.upv.dsic.issi.dplfw.infoelements.ImageIEContents;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;

public class SizedImageEditViewer extends InfoElementAbstractEditViewer {

	

	/**
	 * The load image button listener. Opens a new dialog to select a new
	 * image and updates the {@link ImageIE} contents
	 * 
	 * @author agomez
	 * 
	 */
	private final class LoadSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(SelectionEvent e) {
			ResourceDialog dialog = new ResourceDialog(control.getShell(),
					"Select image...", SWT.OPEN | SWT.SINGLE);
			if (dialog.open() == ResourceDialog.OK) {
				URI imageUri = dialog.getURIs().get(0);
				
				try {
					InputStream inputStream = URIConverter.INSTANCE.createInputStream(imageUri);
					ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
					IOUtils.copy(inputStream, outputStream);
					byte[] bytes = outputStream.toByteArray();
					ImageData imageData = new ImageData(new ByteArrayInputStream(bytes));
					ImageIEContents imageContents = InfoelementsFactory.eINSTANCE.createImageIEContents();
					imageContents.setContents(outputStream.toByteArray());
					getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, imageContents);
					getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, imageData.width);
					getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, imageData.height);
					initializeViewer();
				} catch (IOException e1) {
					e1.printStackTrace();
				} catch (SWTException e2) {
					StatusManager.getManager().handle(
							new Status(Status.ERROR, IESingleEditorPlugin.PLUGIN_ID, e2.getLocalizedMessage(), e2),
							StatusManager.BLOCK | StatusManager.LOG);
				}
			}
		}
	}

	
	/**
	 * The delete image button listener. Resets the {@link ImageIE} contents
	 * 
	 * @author agomez
	 * 
	 */
	private final class ResetSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(SelectionEvent e) {
			getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__IMAGE_CONTENTS, null);
			getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, 0);
			getPropertyModifier().setValue(getInput(), InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, 0);
			initializeViewer();
		}
	}
	
	private final class SaveFeatureChangeDelayed implements Runnable {
		private Object feature;
		private Object value;
		@Override
		public void run() {
			if (getInput() != null && feature != null && value != null) {
				getPropertyModifier().setValue(getInput(), feature, value);
			}
		}
		public void setValues(Object feature, Object value) {
			this.feature = feature;
			this.value = value;
		}
	}
	
	SizedImageEditControl control;
		
	private SaveFeatureChangeDelayed saveWidthChangeDelayed = new SaveFeatureChangeDelayed();
	private SaveFeatureChangeDelayed saveHeightChangeDelayed = new SaveFeatureChangeDelayed();
	
	public SizedImageEditViewer(Composite parent) {
		this(parent, SWT.NONE);
	}

	public SizedImageEditViewer(Composite parent, int style) {
		this(new SizedImageEditControl(parent, style));
	}
	
	public SizedImageEditViewer(SizedImageEditControl imageIEComposite) {
		control = imageIEComposite;
		control.getLoadButton().addSelectionListener(new LoadSelectionAdapter());
		control.getResetButton().addSelectionListener(new ResetSelectionAdapter());
		control.getWidthSpinner().addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				int oldValue = ((ISizedImageLabelProvider) getLabelProvider()).getWidth(getInput());
				int newValue = control.getWidthSpinner().getSelection();
				if (oldValue != newValue) {
					saveWidthChangeDelayed.setValues(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_WIDTH, newValue);
					Display.getDefault().timerExec(800, saveWidthChangeDelayed);
				}
			}
		});
		control.getHeightSpinner().addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				int oldValue = ((ISizedImageLabelProvider) getLabelProvider()).getHeight(getInput());
				int newValue = control.getHeightSpinner().getSelection();
				if (oldValue != newValue) {
					saveHeightChangeDelayed.setValues(InfoelementsPackage.Literals.IMAGE_IE__DISPLAY_HEIGHT, newValue);
					Display.getDefault().timerExec(800, saveHeightChangeDelayed);
				}
			}
		});
	}

	protected void initializeViewer() {
		IIEContentProvider contentProvider = (IIEContentProvider) getContentProvider();
		ISizedImageLabelProvider labelProvider = (ISizedImageLabelProvider) getLabelProvider();

		InfoElement element = contentProvider.getElement(getInput());
		
		if (element != null) {
			byte[] bytes = labelProvider.getImageBytes(element);
			int width = labelProvider.getWidth(element);
			int height = labelProvider.getHeight(element);
			if (!control.isDisposed()) {
				control.getWidthSpinner().setSelection(width);
				control.getHeightSpinner().setSelection(height);
				control.setImageBytes(bytes);
			}
		}
	}
	
	@Override
	public Control getControl() {
		return control;
	}

	
	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}
	
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		Assert.isTrue(labelProvider instanceof ISizedImageLabelProvider);
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		Assert.isTrue(getPropertyModifier() != null,
				"SizedImageViewer must have a property modifier when input is set."); //$NON-NLS-1$
		super.setInput(input);
		
		Assert.isTrue(input instanceof ImageIE,
				"Input of SizedImageViewer must be of ImageIE type."); //$NON-NLS-1$
	}
}
