package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.image;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.eclipse.jface.viewers.BaseLabelProvider;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelements.ImageIE;

public class ImageIELabelProvider extends BaseLabelProvider implements ISizedImageLabelProvider {

	@Override
	public byte[] getImageBytes(Object element) {
		if (element instanceof ImageIE && ((ImageIE) element).getContents() != null) {
			return ((ImageIE) element).getContents();
		} else {
			try {
				return IOUtils.toByteArray(getClass().getResourceAsStream(
						IESingleEditorPlugin.PATH_IMAGE_NO_IMAGE));
			} catch (IOException e) {
				e.printStackTrace();
			}
			return null;
		}
	}

	@Override
	public int getWidth(Object element) {
		if (element instanceof ImageIE) {
			return ((ImageIE)element).getDisplayWidth();
		} else {
			return 0;
		}
	}

	@Override
	public int getHeight(Object element) {
		if (element instanceof ImageIE) {
			return ((ImageIE)element).getDisplayHeight();
		} else {
			return 0;
		}
	}

	

}
