package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEContentProvider;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;

public abstract class InfoElementAbstractDisplayViewer extends ContentViewer implements IIEDisplayViewer {

	private Composite topmostComposite;


	protected InfoElementAbstractDisplayViewer() {
	}
	
	
	/* (non-Javadoc)
	 * @see es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.IIEViewer#getControl()
	 */
	@Override
	public abstract Control getControl();
	
	/* (non-Javadoc)
	 * @see es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.IIEViewer#refresh()
	 */
	@Override
	public void refresh() {
		initializeViewer();
		getTopmostComposite().layout(true, true);
	}

	protected abstract void initializeViewer();

	@Override
	public ISelection getSelection() {
		return StructuredSelection.EMPTY ;
	}

	@Override
	public void setSelection(ISelection selection, boolean reveal) {
	}

	@Override
	protected void inputChanged(Object input, Object oldInput) {
		if (input == oldInput) 
			return;
		else
			initializeViewer();
	}

	/* (non-Javadoc)
	 * @see es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.IIEViewer#setContentProvider(org.eclipse.jface.viewers.IContentProvider)
	 */
	@Override
	public void setContentProvider(IContentProvider contentProvider) {
		Assert.isTrue(contentProvider instanceof IIEContentProvider);
		super.setContentProvider(contentProvider);
	}

	/* (non-Javadoc)
	 * @see es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.IIEViewer#setLabelProvider(org.eclipse.jface.viewers.IBaseLabelProvider)
	 */
	@Override
	public void setLabelProvider(IBaseLabelProvider labelProvider) {
		super.setLabelProvider(labelProvider);
	}

	@Override
	public void setInput(Object input) {
		super.setInput(input);
	}


	protected Composite getTopmostComposite() {
		if (topmostComposite == null) {
			topmostComposite = getControl().getParent();
			do {
				topmostComposite = topmostComposite.getParent();
			} while (topmostComposite.getParent().getParent() != null);
		}
		return topmostComposite;
	}
}