package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.xml.parsers.ParserConfigurationException;

import nu.xom.Serializer;
import nu.xom.converters.DOMConverter;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Document;

import es.upv.dsic.issi.dplfw.infoelements.DitaRepresentable;



public class XMLFormPage extends FormPage {

	private DitaRepresentable ditaRepresentable;
	private Text text;
	
	
	public XMLFormPage(FormEditor editor, DitaRepresentable ditaRepresentable) {
		super(editor, 
				"es.upv.dsic.issi.dplfw.infoelements.presentation.ShowXMLFormPage",
				"DITA");
		this.ditaRepresentable = ditaRepresentable;
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {
		
		
		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		form.getBody().setLayout(layout);
		form.setAlwaysShowScrollBars(false);
		
		text = toolkit.createText(form.getBody(), "", SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		GridData descTextGridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		descTextGridData.grabExcessHorizontalSpace = true;
		descTextGridData.grabExcessVerticalSpace = true;
		descTextGridData.horizontalAlignment = SWT.FILL;
		descTextGridData.widthHint = 200;
		descTextGridData.heightHint = 100;
		text.setLayoutData(descTextGridData);
		
		text.setFont(JFaceResources.getTextFont());
		text.setEditable(false);
		text.setBackground(getSite().getShell().getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		
		form.pack();
	}

	private void refreshText() {
		try {
			Document doc = ditaRepresentable.asDita(null);
		/*
			DOMImplementationLS impl = (DOMImplementationLS) doc.getImplementation();
			LSSerializer serializer = impl.createLSSerializer();
			serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
			String content = serializer.writeToString(doc);
		 */
			ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
			Serializer serializer = new Serializer(outputStream);
			serializer.setIndent(4);
			serializer.setMaxLength(80);
			serializer.write(DOMConverter.convert(doc));
			String content = outputStream.toString("UTF-8");
			text.setText(content != null ?  content : "");
		} catch (UnsupportedOperationException e) {
			MessageDialog.openInformation(getSite().getShell(), "Not implemented yet", 
					"asDita() method not implemented yet for " + ditaRepresentable.getClass().getName() + " elements");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void setActive(boolean active) {
		refreshText();
		super.setActive(active);
	}
	

	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}
}
