package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;

public class VariablesFormPage extends FormPage {

	protected static final int MARGIN_WIDTH = 10;

	private final class ReadOnlyComboKeyListener implements KeyListener {
		@Override
		public void keyReleased(KeyEvent e) {
		}

		@Override
		public void keyPressed(KeyEvent e) {
			
			Combo combo = (Combo) e.getSource();

			// ESC KEY: Hide list and Exit
			if (e.keyCode == SWT.ESC) { 
				combo.setListVisible(false);
				return; 
			} 

			// Navigate (or select) text: doit and exit
			if (e.keyCode == SWT.ARROW_LEFT
					|| e.keyCode == SWT.ARROW_RIGHT
					|| e.keyCode == SWT.HOME
					|| e.keyCode == SWT.END) {
				return; 
			} else if (e.keyCode == SWT.ARROW_UP
					|| e.keyCode == SWT.ARROW_DOWN
					|| e.keyCode == SWT.PAGE_DOWN
					|| e.keyCode == SWT.PAGE_UP) {
				combo.setListVisible(true);
				return; 
			} 
			
			// Save the typed character and continue
			String stringCharacter = Character.toString(e.character);
			
			// Save the current position, as showing the combo may change the selection
			Point selection = combo.getSelection();
			combo.setListVisible(true);

			if (e.keyCode == SWT.BS && selection.x == selection.y) { 
				combo.setSelection(new Point(selection.x - 1, selection.y - 1));
				stringCharacter = "";
			} else if ((e.keyCode == SWT.BS || e.keyCode == SWT.DEL) && selection.x == 0){
				combo.setSelection(new Point(0, 0));
				combo.setText("");
				stringCharacter = "";
			} else {
				combo.setSelection(selection);
			}
			
			String searchString = "";
			
			if (combo.getSelection().x == 0 && StringUtils.isNotEmpty(stringCharacter)) {
				searchString = stringCharacter;
			} else if (combo.getSelection().x == 0 && combo.getSelection().y == combo.getText().length()) {
				searchString = combo.getText();
			} else if (combo.getSelection().x == combo.getSelection().y) {
				searchString = combo.getText().substring(0, combo.getSelection().x) + stringCharacter;
			}

			for (int i = 0; i < combo.getItemCount(); i++) {
				if (StringUtils.isNotEmpty(searchString) && 
						combo.getItem(i).toLowerCase().startsWith(searchString.toLowerCase())) {
					combo.setText(combo.getItem(i));
					combo.select(i);
					combo.setSelection(new Point(searchString.length(), searchString.length()));
					break;
				}
			}
			if (e.character != '\0' && e.character != '\r' && e.character != '\n') {
				e.doit = false;
			}
		}
	}

	private InfoElement infoElement;
	
	private Text uuidText;
	private Text titleText;
	private DateTime creationDate;
	private Combo subjectCombo;
	private Text publisherText;
	private Combo languageCombo;
	private Text descriptionText;
	private TableViewer authorsViewer;
	private TableViewer variablesViewer;
	private FormToolkit toolkit;
	
	public VariablesFormPage(FormEditor editor, InfoElement infoElement) {
		super(editor, 
				"es.upv.dsic.issi.dplfw.infoelements.presentation.EditInfoElementFormPage",
				"Variables");
		this.infoElement = infoElement;
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {
		
		ScrolledForm form = managedForm.getForm();
		toolkit = managedForm.getToolkit();
		form.setText("Info Element Editor");
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = MARGIN_WIDTH;
		layout.rightMargin = MARGIN_WIDTH;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);
		toolkit.decorateFormHeading(form.getForm());	
		
		createVariablesSection(form, toolkit);
	}


	private void createVariablesSection(ScrolledForm form,FormToolkit toolkit) {

		// Section element
		Section section = toolkit.createSection(form.getBody(), 
								Section.DESCRIPTION | Section.TITLE_BAR |
								Section.TWISTIE | Section.EXPANDED);
		
		section.setText("Variables");
		section.setDescription("Variables list of the info element");

		section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));
		section.setLayout(new TableWrapLayout());
		
		// Section client. Contains the elements of the form
		Composite sectionClient = toolkit.createComposite(section);
		sectionClient.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		sectionClient.setLayout(new GridLayout(2, false));
		section.setClient(sectionClient);
		
		// Form elements
		GridData listGridData = new GridData();
		listGridData.grabExcessHorizontalSpace = true;
		listGridData.grabExcessVerticalSpace = true;
		listGridData.horizontalAlignment = SWT.FILL;
		listGridData.verticalAlignment = SWT.FILL;
		listGridData.verticalSpan = 4;
		

		Table variablesTable = toolkit.createTable(sectionClient, SWT.NONE);
		variablesTable.setLayoutData(listGridData);
		variablesViewer = new TableViewer(variablesTable);
		variablesViewer.setContentProvider(new ArrayContentProvider());
		
		variablesViewer.setInput(infoElement.getVariables());
		sectionClient.setData(toolkit);		
		
		Button newButton = toolkit.createButton(sectionClient, "New...", SWT.PUSH);
		newButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));		
		newButton.addSelectionListener(new SelectionAdapter () {
			@Override
			public void widgetSelected(SelectionEvent e) {
				VariablesDialogFormPage dialog = new VariablesDialogFormPage(getSite().getShell());
				if (dialog.open() == InputDialog.OK) {
					
					VariableIEContents varIE = InfoelementsFactory.eINSTANCE.createVariableIEContents();
					varIE.setIdName(dialog.getName());
					varIE.setDescription(dialog.getDescription());
					Command command = AddCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__VARIABLES,varIE);
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					variablesViewer.refresh();
					variablesViewer.setSelection(new StructuredSelection(dialog.getName()), true);
				}
			}
		});
		
		Button removeButton = toolkit.createButton(sectionClient, "Remove", SWT.PUSH);
		removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) variablesViewer.getSelection();
				if (selection.getFirstElement() != null) {
					int index = variablesViewer.getTable().getSelectionIndex();
					Command command = RemoveCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__VARIABLES, selection.getFirstElement());
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					variablesViewer.refresh();
					if (variablesViewer.getElementAt(index) != null)
						variablesViewer.getTable().setSelection(index);
					else if (variablesViewer.getElementAt(index - 1) != null)
						variablesViewer.getTable().setSelection(index - 1);
				}
			}
		});
		

	}
	
	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}
}
