package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariablesDialogFormPage extends Dialog {
  private Text txtVariableName;
  private Text txtDescripton;
  private String variableName = "";
  private String description = "";

  public VariablesDialogFormPage(Shell parentShell) {
    super(parentShell);
   
  }
  
  @Override
  protected Control createDialogArea(Composite parent) {
    Composite container = (Composite) super.createDialogArea(parent);
    
    container.getShell().setText("New variable");
    
    GridLayout layout = new GridLayout(1, false);
    layout.marginRight = 5;
    layout.marginLeft = 10;
    container.setLayout(layout);

    Label lblUser = new Label(container, SWT.NONE);
    lblUser.setText("Variable name:");

    txtVariableName = new Text(container, SWT.BORDER);
    txtVariableName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,
        1, 1));
    txtVariableName.setText(variableName);

    Label lblVariableType = new Label(container, SWT.NONE);
    GridData gridDataLabelVariableType = new GridData(SWT.LEFT, SWT.CENTER, false,
        false, 1, 1);
    gridDataLabelVariableType.horizontalIndent = 1;
    lblVariableType.setLayoutData(gridDataLabelVariableType);
    lblVariableType.setText("Type:");
    
    CCombo comboVariableType = new CCombo(container, SWT.BORDER);
    comboVariableType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
    String types[] = {"Char","String","Integer","Float","Double"};
    comboVariableType.setItems(types);
    
    Label lblDescription = new Label(container, SWT.NONE);
    GridData gd_lblNewLabel = new GridData(SWT.LEFT, SWT.CENTER, false,
        false, 1, 1);
    gd_lblNewLabel.horizontalIndent = 1;
    lblDescription.setLayoutData(gd_lblNewLabel);
    lblDescription.setText("Description:");

    txtDescripton = new Text(container, SWT.BORDER);
    GridData descTextGridData = new GridData(SWT.FILL, SWT.FILL, true, true);
	descTextGridData.grabExcessHorizontalSpace = true;
	descTextGridData.grabExcessVerticalSpace = true;
	descTextGridData.horizontalAlignment = SWT.FILL;
	descTextGridData.widthHint = 200;
	descTextGridData.heightHint = 100;
    txtDescripton.setLayoutData(descTextGridData);
    txtDescripton.setText(description);
    
    return container;
  }

  @Override
  protected Point getInitialSize() {
    return new Point(450, 300);
  }

  @Override
  protected void okPressed() {
    // Copy data from SWT widgets into fields on button press.
    // Reading data from the widgets later will cause an SWT
    // widget diposed exception.
    variableName = txtVariableName.getText();
    description = txtDescripton.getText();
    super.okPressed();
  }

  public String getName() {
    return variableName;
  }

  public void setName(String name) {
    this.variableName = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

} 