/**
 * Copyright (c) 2004 - 2011 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 *    Victor Roldan Betancort - maintenance
 */

/**
 * Modifications by Abel Gomez (Spain)
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.transaction.TransactionException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

import es.upv.dsic.issi.dplfw.infoelements.DitaRepresentable;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;

/**
 * This is an example of a Infoelements model editor. <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * 
 * @generated
 */
public class SingleInfoElementEditor extends FormEditor implements
		IEditingDomainProvider, IMenuListener {

	/**
	 * @ADDED
	 */
	protected CDOView view;

	
	
	protected EObject eObjectInfoElement;
	
	
	/**
	 * This keeps track of the editing domain that is used to track all changes
	 * to the model. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AdapterFactoryEditingDomain editingDomain;

	/**
	 * This is the one adapter factory used for providing views of the model.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory adapterFactory;


	/**
	 * Resources that have been removed since last activation. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Resource> removedResources = new ArrayList<Resource>();

	/**
	 * Resources that have been changed since last activation. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Resource> changedResources = new ArrayList<Resource>();

	/**
	 * Resources that have been saved. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	protected Collection<Resource> savedResources = new ArrayList<Resource>();

	/**
	 * Map to store the diagnostic associated with a resource. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();

	/**
	 * Controls whether the problem indication should be updated. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected boolean updateProblemIndication = true;


	/**
	 * Shows a dialog that asks if conflicting changes should be discarded. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected boolean handleDirtyConflict() {
		return MessageDialog.openQuestion(getSite().getShell(),
				"Conflicting changes", 
				"Conflicting changes. Discard?");
	}

	/**
	 * This creates a model editor. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public SingleInfoElementEditor() {
		super();
		initializeEditingDomain();
	}

	/**
	 * This sets up the editing domain for the model editor. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 */
	protected void initializeEditingDomain() {
		ComposedAdapterFactory.Descriptor.Registry registry = 
				EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
		adapterFactory = new ComposedAdapterFactory(registry);
		adapterFactory.addAdapterFactory(new ResourceItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new ReflectiveItemProviderAdapterFactory());
	}

	/**
	 * This returns the editing domain as required by the
	 * {@link IEditingDomainProvider} interface. This is important for
	 * implementing the static methods of {@link AdapterFactoryEditingDomain}
	 * and for supporting {@link org.eclipse.emf.edit.ui.action.CommandAction}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EditingDomain getEditingDomain() {
		return editingDomain;
	}

	/**
	 * @ADDED
	 */
	public CDOView getView() {
		return view;
	}

	/**
	 * @ADDED
	 */
	public void createModel() {
		try {
			CDOObjectEditorInput editorInput = (CDOObjectEditorInput) getEditorInput();
			view = editorInput.getView();

			// TODO Check if a CommandStack is needed
			BasicCommandStack commandStack = new BasicCommandStack();

			commandStack.addCommandStackListener(new CommandStackListener() {
				@Override
				public void commandStackChanged(final EventObject event) {
					getContainer().getDisplay().asyncExec(new Runnable() {
						public void run() {
							firePropertyChange(IEditorPart.PROP_DIRTY);

						}
					});
				}
			});
			
			ResourceSet resourceSet = view.getResourceSet();
			editingDomain = new AdapterFactoryEditingDomain(adapterFactory, commandStack, resourceSet);

			// This adapter provides the EditingDomain of the Editor
			resourceSet.eAdapters().add(new EditingDomainProviderAdapter());

			String resourcePath = editorInput.getResourcePath();

			if (resourcePath.equals("/")) {
				eObjectInfoElement = view.getRootResource().getEObject(editorInput.getEObjectPath());
			} else { 
				eObjectInfoElement = view.getResource(resourcePath).getEObject(editorInput.getEObjectPath());
			}
			setPartName(eObjectInfoElement.toString());
			
			// Listener to prevent data loss when an external element closes the session
			view.getSession().addListener(new LifecycleEventAdapter() {
				
				@Override
				protected void onAboutToDeactivate(ILifecycle lifecycle) {
					if (isDirty()) {
						boolean save = MessageDialog.openQuestion(
								PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
								"Connection is going to be closed!",
								String.format("'%s' has been modified. Save changes?", getTitle()));
						if (save)
							doSave(null);
					}
				}
				
				@Override
				protected void onDeactivated(ILifecycle lifecycle) {
					if (isDirty()) {
						MessageDialog.openError(
							PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
							"Connection lost!", String.format("Changes on '%s' will be lost.\nConnection closed!", getTitle()));
					}
					closeEditor();
				}
			});
		} catch (RuntimeException ex) {
			ex.printStackTrace();
			throw ex;
		}
	}

	/**
	 * Returns a diagnostic describing the errors and warnings listed in the
	 * resource and the specified exception (if any). <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
		if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
			BasicDiagnostic basicDiagnostic = new BasicDiagnostic(
					Diagnostic.ERROR, "org.eclipse.emf.cdo.ui", 0, "Create model error",
					new Object[] { exception == null ? (Object) resource : exception });
			basicDiagnostic.merge(EcoreUtil.computeDiagnostic(resource, true));
			return basicDiagnostic;
		} else if (exception != null) {
			return new BasicDiagnostic(Diagnostic.ERROR,
					"org.eclipse.emf.cdo.ui", 0, "Create model error",
					new Object[] { exception });
		} else {
			return Diagnostic.OK_INSTANCE;
		}
	}


	/**
	 * @ADDED
	 */
	protected ILabelDecorator createLabelDecorator() {
		return PlatformUI.getWorkbench().getDecoratorManager()
				.getLabelDecorator();
	}

	/**
	 * If there is just one page in the multi-page editor part, this hides the
	 * single tab at the bottom. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected void hideTabs() {
		if (getPageCount() <= 1) {
			setPageText(0, ""); //$NON-NLS-1$
			if (getContainer() != null && !getContainer().isDisposed()
					&& getContainer() instanceof CTabFolder) {
				((CTabFolder) getContainer()).setTabHeight(1);
				Point point = getContainer().getSize();
				getContainer().setSize(point.x, point.y + 6);
			}
		}
	}

	/**
	 * If there is more than one page in the multi-page editor part, this shows
	 * the tabs at the bottom. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected void showTabs() {
		if (getPageCount() > 1) {
			setPageText(0, "Details");
			if (getContainer() != null && !getContainer().isDisposed()
					&& getContainer() instanceof CTabFolder) {
				((CTabFolder) getContainer()).setTabHeight(SWT.DEFAULT);
				Point point = getContainer().getSize();
				getContainer().setSize(point.x, point.y - 6);
			}
		}
	}

	/**
	 * This is used to track the active viewer. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void pageChange(int pageIndex) {
		super.pageChange(pageIndex);
	}

	/**
	 * This is how the framework determines which interfaces we implement. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public <T> T getAdapter(Class<T> key) {
		if (key.equals(IGotoMarker.class)) {
			return key.cast(this);
		}
		else {
			return super.getAdapter(key);
		}
	}
	/**
	 * This is for implementing {@link IEditorPart} and simply tests the command
	 * stack. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public boolean isDirty() {
		return view.isDirty();
	}

	/**
	 * This is for implementing {@link IEditorPart} and simply saves the model
	 * file. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 */
	@Override
	public void doSave(IProgressMonitor progressMonitor) {
		Display.getCurrent().asyncExec(null);
		// Save only resources that have actually changed.
		//
		final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
		saveOptions.put(Resource.OPTION_SAVE_ONLY_IF_CHANGED,
				Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);

		IRunnableWithProgress operation = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor)
					throws InvocationTargetException, InterruptedException {
				boolean first = true;
				EList<Resource> resources = CDOUtil.getResources(editingDomain
						.getResourceSet());
				resources.add(view.getRootResource());
				monitor.beginTask("", resources.size()); //$NON-NLS-1$
				try {
					for (Resource resource : resources) {
						if ((first || !resource.getContents().isEmpty() || isPersisted(resource))
								&& !editingDomain.isReadOnly(resource)) {
							try {
								savedResources.add(resource);
								saveOptions
										.put(CDOResource.OPTION_SAVE_PROGRESS_MONITOR,
												SubMonitor.convert(monitor,	1));
								
								// TODO: Prompt users about how to resolve conflicts!!
								saveOptions
										.put(CDOResource.OPTION_SAVE_OVERRIDE_TRANSACTION,
												view);
								resource.save(saveOptions);
							} catch (TransactionException exception) {
								exception.printStackTrace();
								CDOTransaction transaction = (CDOTransaction) view;
								transaction.rollback();
							} catch (Exception exception) {
								exception.printStackTrace();
								resourceToDiagnosticMap.put(resource, analyzeResourceProblems(resource, exception));
							}

							first = false;
						} else {
							monitor.worked(1);
						}
					}
				} finally {
					monitor.done();
				}
			}
		};

		updateProblemIndication = false;

		try {
			// This runs the options, and shows progress.
			//
			new ProgressMonitorDialog(getSite().getShell()).run(true, true,
					operation);

			// Refresh the necessary state.
			//
			((BasicCommandStack) editingDomain.getCommandStack()).saveIsDone();
		} catch (Exception exception) {
			// Something went wrong that shouldn't.
			//
			exception.printStackTrace();
		}

		updateProblemIndication = true;
		editorDirtyStateChanged();
	}

	/**
	 * This returns whether something has been persisted to the URI of the
	 * specified resource. The implementation uses the URI converter from the
	 * editor's resource set to try to open an input stream. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected boolean isPersisted(Resource resource) {
		boolean result = false;
		try {
			InputStream stream = editingDomain.getResourceSet()
					.getURIConverter().createInputStream(resource.getURI());
			if (stream != null) {
				result = true;
				stream.close();
			}
		} catch (IOException e) {
			// Ignore
		}
		return result;
	}

	/**
	 * This always returns false because it is not currently supported. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 */
	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * This also changes the editor's input. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void doSaveAs() {
		SaveAsDialog saveAsDialog = new SaveAsDialog(getSite().getShell());
		saveAsDialog.open();
		IPath path = saveAsDialog.getResult();
		if (path != null) {
			IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
			if (file != null) {
				doSaveAs(URI.createPlatformResourceURI(file.getFullPath()
						.toString(), true), new FileEditorInput(file));
			}
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected void doSaveAs(URI uri, IEditorInput editorInput) {
		throw new UnsupportedOperationException();

		// CDONet4jUtil.getResources(editingDomain.getResourceSet()).get(0).setURI(uri);
		// setInputWithNotify(editorInput);
		// setPartName(editorInput.getName());
		// IProgressMonitor progressMonitor =
		// getActionBars().getStatusLineManager() != null ? getActionBars()
		// .getStatusLineManager().getProgressMonitor() : new
		// NullProgressMonitor();
		// doSave(progressMonitor);
	}

	/**
	 * This is called during startup. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 */
	@Override
	public void init(IEditorSite site, IEditorInput editorInput) {
		setSite(site);
		setPartName(editorInput.getName());
		setInputWithNotify(editorInput);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setFocus() {
		getControl(getActivePage()).setFocus();
	}


	/**
	 * This implements {@link org.eclipse.jface.action.IMenuListener} to help
	 * fill the context menus with contributions from the Edit menu. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 */
	public void menuAboutToShow(IMenuManager menuManager) {
	}

	/**
	 * @ADDED
	 */
	@Override
	public void dispose() {
		updateProblemIndication = false;

		if (!view.isClosed()) {
			try {
				if (adapterFactory != null) {
					adapterFactory.dispose();
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}

		if (((CDOObjectEditorInput) getEditorInput()).isViewOwned()) {
			view.close();
		}

		super.dispose();
	}


	/**
	 * @ADDED
	 */
	protected void fireDirtyPropertyChange() {
		try {
			getSite().getShell().getDisplay().asyncExec(new Runnable() {
				public void run() {
					try {
						firePropertyChange(IEditorPart.PROP_DIRTY);
					} catch (Exception ignore) {
					}
				}
			});
		} catch (Exception ignore) {
		}
	}

	/**
	 * @ADDED
	 */
	protected void closeEditor() {
		try {
			getSite().getShell().getDisplay().asyncExec(new Runnable() {
				public void run() {
					try {
						getSite().getPage().closeEditor(SingleInfoElementEditor.this, false);
						SingleInfoElementEditor.this.dispose();
					} catch (RuntimeException ignore) {
						// Do nothing
					}
				}
			});
		} catch (RuntimeException ignore) {
			// Do nothing
		}
	}

	/**
	 * Adapter that provides the current EditingDomain
	 * 
	 * @since 2.0
	 */
	private class EditingDomainProviderAdapter implements Adapter, IEditingDomainProvider {
		public boolean isAdapterForType(Object type) {
			return type == IEditingDomainProvider.class;
		}

		public EditingDomain getEditingDomain() {
			return editingDomain;
		}

		public Notifier getTarget() {
			return null;
		}

		public void notifyChanged(Notification notification) {
		}

		public void setTarget(Notifier newTarget) {
		}
	}

	@Override
	protected void addPages() {
		
		createModel();
		
		try {
			addPage(new MetadataFormPage(this, (InfoElement) eObjectInfoElement));
			addPage(new VariablesFormPage(this, (InfoElement) eObjectInfoElement));
			addPage(new EditFormPage(this, (InfoElement) eObjectInfoElement));
			addPage(new PreviewFormPage(this, (InfoElement) eObjectInfoElement));
			if (eObjectInfoElement instanceof DitaRepresentable)
				addPage(new XMLFormPage(this, (DitaRepresentable) eObjectInfoElement));
		} catch (PartInitException e) {
			e.printStackTrace();
		}
	}
}
