package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;



public class PreviewFormPage extends AbstractContentFormPage {

	static final String GENERIC_DISPLAY_DESCRIPTION = "Preview of the Info Element";
	Section previewSection;
	
	public PreviewFormPage(FormEditor editor, InfoElement infoElement) {
		this(editor, infoElement, "Preview");
	}

	public PreviewFormPage(FormEditor editor, InfoElement infoElement, String activityName) {
		super(editor, 
				"es.upv.dsic.issi.dplfw.infoelements.presentation.EditContentFormPage",
				activityName);
		this.infoElement = infoElement;
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {
		
		String description = null;

		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();
		form.setText("Info Element Editor");
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = MARGIN_WIDTH;
		layout.rightMargin = MARGIN_WIDTH;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);
		form.setDelayedReflow(true);
		toolkit.decorateFormHeading(form.getForm());	

		IConfigurationElement configElement;
		try {
			configElement = getConfigurationElementForIE(infoElement);
			previewSection = createSection(form, toolkit, configElement, false);
			if (previewSection != null) {
				previewSection.setText("Preview contents");
				description = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_DISPLAY_DESCRIPTION);
				previewSection.setDescription(description != null ? description : GENERIC_DISPLAY_DESCRIPTION);
				previewSection.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
			}		
		} catch (ClassNotFoundException e) {
			throw new WrappedException(
					NLS.bind("Unable to create previewer for {0}", infoElement.getClass().toString()), e);
		}
		
		//form.pack();
		form.reflow(true);
	}

	
	protected IIEDisplayViewer createViewer(Composite parent, ScrolledForm scrolledForm, FormToolkit toolkit, InfoElement infoElement, IConfigurationElement configElement ) throws ClassNotFoundException {
		
		IIEDisplayViewer ieViewer = null;
		try {
			// Hack to allow arguments in the IEDisplayViewer constructor
			// (createExecutableExtension does not allow arguments) 
			String viewerClassName = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_DISPLAY_VIEWER);
			if (viewerClassName == null) {
				throw new ClassNotFoundException();
			}
			Class<?> viewerClass = Class.forName(viewerClassName);
			Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class, Integer.TYPE);
			ieViewer = (IIEDisplayViewer) viewerConstructor.newInstance(parent, SWT.BORDER);
			// EOH (End Of Hack)
			
			IContentProvider contentProvider = (IContentProvider) configElement
					.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_CONTENT_PROVIDER);
			IBaseLabelProvider labelProvider = (IBaseLabelProvider) configElement
					.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_LABEL_PROVIDER);
			
			ieViewer.setContentProvider(contentProvider);
			ieViewer.setLabelProvider(labelProvider);
			ieViewer.setInput(infoElement);
			
			if (ieViewer.getControl() instanceof Composite) {
				cascadeAdapt((Composite) ieViewer.getControl(), toolkit);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		return ieViewer;
	}
}
