package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import java.util.Calendar;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.preferences.PreferenceConstants;
import es.upv.dsic.issi.dplfw.infoelements.ISO_Language;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;

public class MetadataFormPage extends FormPage {

	private final class ReadOnlyComboKeyListener implements KeyListener {
		@Override
		public void keyReleased(KeyEvent e) {
		}

		@Override
		public void keyPressed(KeyEvent e) {
			
			Combo combo = (Combo) e.getSource();

			// ESC KEY: Hide list and Exit
			if (e.keyCode == SWT.ESC) { 
				combo.setListVisible(false);
				return; 
			} 

			// Navigate (or select) text: doit and exit
			if (e.keyCode == SWT.ARROW_LEFT
					|| e.keyCode == SWT.ARROW_RIGHT
					|| e.keyCode == SWT.HOME
					|| e.keyCode == SWT.END) {
				return; 
			} else if (e.keyCode == SWT.ARROW_UP
					|| e.keyCode == SWT.ARROW_DOWN
					|| e.keyCode == SWT.PAGE_DOWN
					|| e.keyCode == SWT.PAGE_UP) {
				combo.setListVisible(true);
				return; 
			} 
			
			// Save the typed character and continue
			String stringCharacter = Character.toString(e.character);
			
			// Save the current position, as showing the combo may change the selection
			Point selection = combo.getSelection();
			combo.setListVisible(true);

			if (e.keyCode == SWT.BS && selection.x == selection.y) { 
				combo.setSelection(new Point(selection.x - 1, selection.y - 1));
				stringCharacter = "";
			} else if ((e.keyCode == SWT.BS || e.keyCode == SWT.DEL) && selection.x == 0){
				combo.setSelection(new Point(0, 0));
				combo.setText("");
				stringCharacter = "";
			} else {
				combo.setSelection(selection);
			}
			
			String searchString = "";
			
			if (combo.getSelection().x == 0 && StringUtils.isNotEmpty(stringCharacter)) {
				searchString = stringCharacter;
			} else if (combo.getSelection().x == 0 && combo.getSelection().y == combo.getText().length()) {
				searchString = combo.getText();
			} else if (combo.getSelection().x == combo.getSelection().y) {
				searchString = combo.getText().substring(0, combo.getSelection().x) + stringCharacter;
			}

			for (int i = 0; i < combo.getItemCount(); i++) {
				if (StringUtils.isNotEmpty(searchString) && 
						combo.getItem(i).toLowerCase().startsWith(searchString.toLowerCase())) {
					combo.setText(combo.getItem(i));
					combo.select(i);
					combo.setSelection(new Point(searchString.length(), searchString.length()));
					break;
				}
			}
			if (e.character != '\0' && e.character != '\r' && e.character != '\n') {
				e.doit = false;
			}
		}
	}

	private InfoElement infoElement;
	
	private Text uuidText;
	private Text titleText;
	private DateTime creationDate;
	private Combo subjectCombo;
	private Text publisherText;
	private Combo languageCombo;
	private Text descriptionText;
	private TableViewer authorsViewer;
	private TableViewer keywordsViewer;
	
	public MetadataFormPage(FormEditor editor, InfoElement infoElement) {
		super(editor, 
				"es.upv.dsic.issi.dplfw.infoelements.presentation.EditInfoElementFormPage",
				"Metadata");
		this.infoElement = infoElement;
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {
		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();
		form.setText("Info Element Editor");
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = 10;
		layout.rightMargin = 10;
		layout.numColumns = 2;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);
		toolkit.decorateFormHeading(form.getForm());	
		
		createBasicMetadataSection(form, toolkit);
		loadBasicMetadata();
		createAuthorsSection(form, toolkit);
		createKeywordsSection(form, toolkit);
	}

	
	private void createBasicMetadataSection(final ScrolledForm form, FormToolkit toolkit) {
		

		// Section element
		Section section = toolkit.createSection(form.getBody(), 
								Section.DESCRIPTION | Section.TITLE_BAR |
								Section.TWISTIE | Section.EXPANDED);
		
		section.setText("Basic metadata");
		section.setDescription("Basic metadata of the info element");

		section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 2));
		section.setLayout(new FillLayout());
		
		// Section client. Contains the elements of the form
		Composite sectionClient = toolkit.createComposite(section);
		sectionClient.setLayout(new GridLayout(2, false));
		section.setClient(sectionClient);

		
		// Form elements
		GridData gdHSpan2 = new GridData();
		gdHSpan2.grabExcessHorizontalSpace = true;
		gdHSpan2.horizontalAlignment = SWT.FILL;

		// Label uuidLabel = 
		toolkit.createLabel(sectionClient, "UUID:");
		uuidText = toolkit.createText(sectionClient, "");
		uuidText.setEditable(false);
		uuidText.setEnabled(false);
//		uuidText.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
//		uuidText.setForeground(Display.getDefault().getSystemColor(SWT.COLOR_WIDGET_DARK_SHADOW));
		uuidText.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, false));

		
		// Label titleLabel = 
		toolkit.createLabel(sectionClient, "Title:");
		titleText = toolkit.createText(sectionClient, "");
		titleText.setLayoutData(gdHSpan2);

		// Label creationLabel = 
		toolkit.createLabel(sectionClient, "Date of Creation:");
		creationDate = new DateTime (sectionClient, SWT.DATE | SWT.LONG | SWT.DROP_DOWN);
		creationDate.setLayoutData(gdHSpan2);
		toolkit.adapt(creationDate);

		// Label SubjectLabel = 
		toolkit.createLabel(sectionClient, "Subject:");
		subjectCombo = new Combo(sectionClient, SWT.DROP_DOWN);
		String[] subjects = IESingleEditorPlugin.getDefault().getPreferenceStore()
				.getString(PreferenceConstants.P_SUBJECTS).split(IESingleEditorPlugin.IESUBJECTS_SEPARATOR);
		subjectCombo.add("");
		for (String subject : subjects) {
			subjectCombo.add(subject);
		}
		toolkit.adapt(subjectCombo, false, false);
		subjectCombo.setLayoutData(gdHSpan2);
		subjectCombo.addKeyListener(new ReadOnlyComboKeyListener());
		subjectCombo.setVisibleItemCount(10);
		
		// Label publisherLabel = 
		toolkit.createLabel(sectionClient, "Publisher:");
		publisherText = toolkit.createText(sectionClient, "");
		publisherText.setLayoutData(gdHSpan2);

		// Label languageLabel = 
		toolkit.createLabel(sectionClient, "Language:");
		languageCombo = new Combo(sectionClient, SWT.DROP_DOWN);
		for (ISO_Language lang : ISO_Language.values()) {
			languageCombo.add(lang.getLiteral());
		}
		toolkit.adapt(languageCombo, false, false);
		languageCombo.setLayoutData(gdHSpan2);
		languageCombo.addKeyListener(new ReadOnlyComboKeyListener());
		languageCombo.setVisibleItemCount(10);

		
		// Label descriptionLabel = 
		toolkit.createLabel(sectionClient, "Description:");
		descriptionText = toolkit.createText(sectionClient, "", SWT.MULTI | SWT.V_SCROLL | SWT.WRAP);
		GridData descTextGridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		descTextGridData.grabExcessHorizontalSpace = true;
		descTextGridData.grabExcessVerticalSpace = true;
		descTextGridData.horizontalAlignment = SWT.FILL;
		descTextGridData.widthHint = 200;
		descTextGridData.heightHint = 100;
		

		descriptionText.setLayoutData(descTextGridData);
		toolkit.adapt(descriptionText, true, false);
	}
	
	
	private void createAuthorsSection(final ScrolledForm form, FormToolkit toolkit) {
		

		// Section element
		Section section = toolkit.createSection(form.getBody(), 
								Section.DESCRIPTION | Section.TITLE_BAR |
								Section.TWISTIE | Section.EXPANDED);
		
		section.setText("Authors");
		section.setDescription("Enter the authors which have contributed this Info Element to the repository.");

		section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));
		section.setLayout(new TableWrapLayout());
		
		// Section client. Contains the elements of the form
		Composite sectionClient = toolkit.createComposite(section);
		sectionClient.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		sectionClient.setLayout(new GridLayout(2, false));
		section.setClient(sectionClient);

		
		// Form elements
		GridData listGridData = new GridData();
		listGridData.grabExcessHorizontalSpace = true;
		listGridData.grabExcessVerticalSpace = true;
		listGridData.horizontalAlignment = SWT.FILL;
		listGridData.verticalAlignment = SWT.FILL;
		listGridData.verticalSpan = 4;
		
		
		Table authorsTable = toolkit.createTable(sectionClient, SWT.NONE);
		authorsTable.setLayoutData(listGridData);
		authorsViewer = new TableViewer(authorsTable);
		
		authorsViewer.setContentProvider(new ArrayContentProvider());
		authorsViewer.setInput(infoElement.getAuthor());
		
		Button newButton = toolkit.createButton(sectionClient, "New...", SWT.PUSH);
		newButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		newButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				InputDialog dialog = new InputDialog(getSite().getShell(),
						"New Author", "Enter an author name:", "", null);
				if (dialog.open() == InputDialog.OK) {
					Command command = AddCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, dialog.getValue());
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					authorsViewer.refresh();
					authorsViewer.setSelection(new StructuredSelection(dialog.getValue()), true);
				}
			}
		});
		Button removeButton = toolkit.createButton(sectionClient, "Remove", SWT.PUSH);
		removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) authorsViewer.getSelection();
				if (selection.getFirstElement() != null) {
					int index = authorsViewer.getTable().getSelectionIndex();
					Command command = RemoveCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, selection.getFirstElement());
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					authorsViewer.refresh();
					if (authorsViewer.getElementAt(index) != null)
						authorsViewer.getTable().setSelection(index);
					else if (authorsViewer.getElementAt(index - 1) != null)
						authorsViewer.getTable().setSelection(index - 1);
				}
			}
		});
		Button upButton = toolkit.createButton(sectionClient, "Up", SWT.PUSH);
		upButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		upButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) authorsViewer.getSelection();
				int newPos = infoElement.getAuthor().indexOf(selection.getFirstElement()) - 1;
				Command command = MoveCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, selection.getFirstElement(), newPos);
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
				authorsViewer.refresh();
			}
		});
		Button downButton = toolkit.createButton(sectionClient, "Down", SWT.PUSH);
		downButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		downButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) authorsViewer.getSelection();
				int newPos = infoElement.getAuthor().indexOf(selection.getFirstElement()) + 1;
				Command command = MoveCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__AUTHOR, selection.getFirstElement(), newPos);
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
				authorsViewer.refresh();
			}
		});
		
	}
	
	
	private void createKeywordsSection(final ScrolledForm form, FormToolkit toolkit) {
		

		// Section element
		Section section = toolkit.createSection(form.getBody(), 
								Section.DESCRIPTION | Section.TITLE_BAR |
								Section.TWISTIE | Section.EXPANDED);
		
		section.setText("Keywords");
		section.setDescription("Keywords describing this Info Element."	+
				"Keywords are used when searching for Info Elements in the repository.");

		section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));
		section.setLayout(new TableWrapLayout());
		
		// Section client. Contains the elements of the form
		Composite sectionClient = toolkit.createComposite(section);
		sectionClient.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		sectionClient.setLayout(new GridLayout(2, false));
		section.setClient(sectionClient);

		
		// Form elements
		GridData listGridData = new GridData();
		listGridData.grabExcessHorizontalSpace = true;
		listGridData.grabExcessVerticalSpace = true;
		listGridData.horizontalAlignment = SWT.FILL;
		listGridData.verticalAlignment = SWT.FILL;
		listGridData.verticalSpan = 4;
		

		Table keywordsTable = toolkit.createTable(sectionClient, SWT.NONE);
		keywordsTable.setLayoutData(listGridData);
		keywordsViewer = new TableViewer(keywordsTable);
		keywordsViewer.setContentProvider(new ArrayContentProvider());
		keywordsViewer.setInput(infoElement.getKeywords());
		
		Button newButton = toolkit.createButton(sectionClient, "New...", SWT.PUSH);
		newButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		newButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				InputDialog dialog = new InputDialog(getSite().getShell(),
						"New keyword", "Enter a new keyword:", "", null);
				if (dialog.open() == InputDialog.OK) {
					Command command = AddCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, dialog.getValue());
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					keywordsViewer.refresh();
					keywordsViewer.setSelection(new StructuredSelection(dialog.getValue()), true);
				}
			}
		});
		Button removeButton = toolkit.createButton(sectionClient, "Remove", SWT.PUSH);
		removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) keywordsViewer.getSelection();
				if (selection.getFirstElement() != null) {
					int index = keywordsViewer.getTable().getSelectionIndex();
					Command command = RemoveCommand.create(getEditingDomain(), infoElement,
							InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, selection.getFirstElement());
					if (command.canExecute()) {
						getEditingDomain().getCommandStack().execute(command);
					}
					keywordsViewer.refresh();
					if (keywordsViewer.getElementAt(index) != null)
						keywordsViewer.getTable().setSelection(index);
					else if (keywordsViewer.getElementAt(index - 1) != null)
						keywordsViewer.getTable().setSelection(index - 1);
				}
			}
		});
		
		Button upButton = toolkit.createButton(sectionClient, "Up", SWT.PUSH);
		upButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		upButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) keywordsViewer.getSelection();
				int newPos = infoElement.getKeywords().indexOf(selection.getFirstElement()) - 1;
				Command command = MoveCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, selection.getFirstElement(), newPos);
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
				keywordsViewer.refresh();
			}
		});
		Button downButton = toolkit.createButton(sectionClient, "Down", SWT.PUSH);
		downButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		downButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) keywordsViewer.getSelection();
				int newPos = infoElement.getKeywords().indexOf(selection.getFirstElement()) + 1;
				Command command = MoveCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__KEYWORDS, selection.getFirstElement(), newPos);
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
				keywordsViewer.refresh();
			}
		});
	}


	private void loadBasicMetadata() {

		//
		// UUID 
		//
		
		// Retrieve
		if (infoElement.getUuid() != null) {
			uuidText.setText(infoElement.getUuid().toString());
		}
		
	
		//
		// Title 
		//
		
		// Retrieve
		if (infoElement.getTitle() != null) {
			titleText.setText(infoElement.getTitle());
		}
		
		// Save
		titleText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__TITLE, ((Text)e.getSource()).getText());
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
		
		
		//
		// Creation Date 
		//
		
		// Retrieve
		if (infoElement.getDateCreation() != null) {
			Calendar cal = Calendar.getInstance(); 
			cal.setTime(infoElement.getDateCreation());
			
			creationDate.setDate(cal.get(Calendar.YEAR), 
					cal.get(Calendar.MONTH),
					cal.get(Calendar.DAY_OF_MONTH));
		}
		
		// Save 
		creationDate.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Calendar cal = Calendar.getInstance();
				cal.set(creationDate.getYear(), creationDate.getMonth(), creationDate.getDay(), 0, 0, 0);
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__DATE_CREATION, cal.getTime());
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
		
		//
		// Subject 
		//
		
		// Retrieve
		if (infoElement.getSubject() != null) {
			subjectCombo.setText(infoElement.getSubject());
		}
		
		// Save
		subjectCombo.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__SUBJECT, ((Combo)e.getSource()).getText());
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
		
		
		//
		// Publisher 
		//
		
		// Retrieve
		if (infoElement.getPublisher() != null) {
			publisherText.setText(infoElement.getPublisher());
		}
		
		// Save
		publisherText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__PUBLISHER, ((Text)e.getSource()).getText());
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
		
		
		//
		// Language 
		//
		
		// Retrieve
		if (infoElement.getLanguage() != null) {
			languageCombo.setText(infoElement.getLanguage().getLiteral());
		}
		
		// Save
		languageCombo.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__LANGUAGE, ISO_Language.get(((Combo)e.getSource()).getText()));
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
		
		//
		// Description 
		//
		
		// Retrieve
		if (infoElement.getDescription() != null) {
			descriptionText.setText(infoElement.getDescription());
		}
		
		// Save
		descriptionText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Command command = SetCommand.create(getEditingDomain(), infoElement,
						InfoelementsPackage.Literals.INFO_ELEMENT__DESCRIPTION, ((Text)e.getSource()).getText());
				if (command.canExecute()) {
					getEditingDomain().getCommandStack().execute(command);
				}
			}
		});
	}
	
	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}
}
