package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementPropertyModifier;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;



public class EditFormPage extends AbstractContentFormPage {

	private static final String GENERIC_EDIT_DESCRIPTION = "Edit de contents of the Info Element";
	private Section editSection;
	
	public EditFormPage(FormEditor editor, InfoElement imageIE, String tabText) {
		super(editor, 
				"es.upv.dsic.issi.dplfw.infoelements.presentation.EditContentFormPage",
				tabText);
		this.infoElement = imageIE;
	}
	
	public EditFormPage(FormEditor editor, InfoElement imageIE) {
		this(editor, imageIE, "Contents");
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {
		
		String description = null;

		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();
		form.setText("Info Element Editor");
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = MARGIN_WIDTH;
		layout.rightMargin = MARGIN_WIDTH;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);
		form.setDelayedReflow(true);
		toolkit.decorateFormHeading(form.getForm());	

		IConfigurationElement configElement;
		try {
			configElement = getConfigurationElementForIE(infoElement);
		
			editSection = createSection(form, toolkit, configElement, true);
			if (editSection != null) {
				editSection.setText("Edit contents");
				description = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_EDIT_DESCRIPTION);
				editSection.setDescription(description != null ? description : GENERIC_EDIT_DESCRIPTION);
				editSection.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
				
	//			form.addListener(SWT.Resize, new Listener() {
	//				@Override
	//				public void handleEvent(Event event) {
	//					TableWrapData tableWrapData = new TableWrapData();
	//					tableWrapData.maxWidth = getManagedForm().getForm().getSize().x - MARGIN_WIDTH * 4;
	//					editSection.setLayoutData(tableWrapData);
	//				}
	//			});
			}
		} catch (ClassNotFoundException e) {
			throw new WrappedException(
					NLS.bind("Unable to create editor viewer for {0}", infoElement.getClass().toString()), e);
		}

		//form.pack();
		form.reflow(true);
	}

	
	protected IIEDisplayViewer createViewer(Composite parent, ScrolledForm scrolledForm, FormToolkit toolkit, InfoElement infoElement, IConfigurationElement configElement ) throws ClassNotFoundException {
		
		IIEEditViewer ieViewer = null;
		try {
			// Hack to allow arguments in the IEViewer constructor
			// (createExecutableExtension does not allow arguments) 
			String viewerClassName = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_EDIT_VIEWER);
			if (viewerClassName == null) {
				throw new ClassNotFoundException();
			}
			Class<?> viewerClass = Class.forName(viewerClassName);
			Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class, Integer.TYPE);
			ieViewer = (IIEEditViewer) viewerConstructor.newInstance(parent, SWT.NONE);
			// EOH (End Of Hack)
			
			IContentProvider contentProvider = (IContentProvider) configElement
					.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_CONTENT_PROVIDER);
			IBaseLabelProvider labelProvider = (IBaseLabelProvider) configElement
					.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_LABEL_PROVIDER);

			ieViewer.setContentProvider(contentProvider);
			ieViewer.setLabelProvider(labelProvider);
			ieViewer.setPropertyModifier(new InfoElementPropertyModifier(getEditingDomain()));
			ieViewer.setInput(infoElement);
			
			if (ieViewer.getControl() instanceof Composite) {
				cascadeAdapt((Composite) ieViewer.getControl(), toolkit);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		return ieViewer;
	}
}
