/**
 * Copyright (c) 2004 - 2011 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 *    Victor Roldan Betancort - maintenance
 */
package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.ui.IPersistableElement;

/**
 * @author Eike Stepper
 * @since 2.0
 */
public class CDOObjectEditorInput extends PlatformObject implements CDOEditorInput {
	private CDOView view;

	private boolean viewOwned;

	private String resourcePath;

	private String eObjectPath;

	public CDOObjectEditorInput(CDOView view, String resourcePath, String eObjectPath) {
		this(view, resourcePath, eObjectPath, false);
	}

	public CDOObjectEditorInput(CDOView view, String resourcePath, String eObjectPath, boolean viewOwned) {
		this.view = view;
		this.viewOwned = viewOwned;
		this.resourcePath = resourcePath;
		this.eObjectPath = eObjectPath;
	}

	public CDOView getView() {
		return view;
	}

	public boolean isViewOwned() {
		return viewOwned;
	}

	public String getResourcePath() {
		return resourcePath;
	}

	public String getEObjectPath() {
		return eObjectPath;
	}

	public boolean exists() {
		return true;
	}

	public ImageDescriptor getImageDescriptor() {
		return CDOItemProvider.getViewImageDescriptor(view);
	}

	public String getName() {
		if (resourcePath != null) {
			return new Path(resourcePath).lastSegment() != null ? new Path(resourcePath).lastSegment() : "";
		}

		return view.getSession().getRepositoryInfo().getName();
	}

	public IPersistableElement getPersistable() {
		return null;
	}

	public String getToolTipText() {
		if (view.isClosed()) {
			return "";
		}

		CDOSession session = view.getSession();
		String repositoryName = session.getRepositoryInfo().getName();

		StringBuilder builder = new StringBuilder();
		builder.append(repositoryName);
		if (resourcePath != null) {
			builder.append(resourcePath);
		}

		builder.append(" ["); //$NON-NLS-1$
		builder.append(session.getSessionID());
		builder.append(":"); //$NON-NLS-1$
		builder.append(view.getViewID());
		builder.append("]"); //$NON-NLS-1$

		if (view.isReadOnly()) {
			builder.append(" readonly"); //$NON-NLS-1$
		}

		long timeStamp = view.getTimeStamp();
		if (timeStamp != CDOView.UNSPECIFIED_DATE) {
			builder.append(CDOCommonUtil.formatTimeStamp(timeStamp));
		}

		return builder.toString();
	}

	@Override
	public int hashCode() {
		/* An editor input is considered equivalent to another one 
		 * if both inputs are the same resource.
		 * The view is not considered, be careful about leaving unused 
		 * open transactions
		 */
		return /* ObjectUtil.hashCode(view) ^ */ 
				ObjectUtil.hashCode(eObjectPath) ^ 
				ObjectUtil.hashCode(resourcePath);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}

		if (obj instanceof CDOObjectEditorInput) {
			CDOObjectEditorInput that = (CDOObjectEditorInput) obj;
			/* An editor input is considered equivalent to another one 
			 * if both inputs are the same resource.
			 * The view is not considered, be careful about leaving unused 
			 * open transactions
			 */
			return ObjectUtil.equals(resourcePath, that.resourcePath)
					&& ObjectUtil.equals(eObjectPath, that.eObjectPath)
					/*&& ObjectUtil.equals(view, that.view)*/;
		}

		return false;
	}
	@Override
	protected void finalize() throws Throwable {
		if (isViewOwned() && !view.isClosed())
			view.close();
		super.finalize();
	}
}
