package es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.statushandlers.StatusManager;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;

public abstract class AbstractContentFormPage extends FormPage {

	protected static final int MARGIN_WIDTH = 10;
	protected InfoElement infoElement;
	private ProgressMonitorDialog busyDialog;

	public AbstractContentFormPage(String id, String title) {
		super(id, title);
	}

	public AbstractContentFormPage(FormEditor editor, String id, String title) {
		super(editor, id, title);
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) {
		super.init(site, input);
	}

	@Override
	public void initialize(FormEditor editor) {
		super.initialize(editor);
	}

	@Override
	public void createPartControl(Composite parent) {
		try {
			showBusy(true);
			super.createPartControl(parent);
		} finally {
			showBusy(false);
		}
	}

	@Override
	public void showBusy(boolean busy) {
		if (busy) {
			if (busyDialog == null) {
				busyDialog = new ProgressMonitorDialog(getSite().getShell());
				busyDialog.setBlockOnOpen(false);
			}
			busyDialog.open();
		} else {
			busyDialog.close();
		}
	}



	protected Section createSection(final ScrolledForm scrolledForm, FormToolkit toolkit, IConfigurationElement configElement,
			boolean editable) {
				
				Section section = toolkit.createSection(scrolledForm.getBody(), 
										Section.DESCRIPTION | Section.TITLE_BAR |
										Section.TWISTIE | Section.EXPANDED);
				
				final Composite c = toolkit.createComposite(section);
				
				if (configElement == null) {
					c.setLayout(new GridLayout(1, false));
					Label label = toolkit.createLabel(c, String.format("No content handler available for elements of type '%s'", infoElement.getClass().getName()));
					label.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));
					label.setFont(JFaceResources.getFontRegistry().getBold(JFaceResources.DEFAULT_FONT));
					label.setForeground(JFaceColors.getErrorText(getSite().getShell().getDisplay()));
				} else {
					c.setLayout(new TableWrapLayout());
					c.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
					section.setLayout(new TableWrapLayout());
			
					try {
						IIEDisplayViewer viewer = 
							createViewer(c, scrolledForm, toolkit, infoElement, configElement);
						
						viewer.getControl().setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
						
						// This listener forces the form to reflow when the child viewer is resized
						viewer.getControl().addListener(SWT.Resize, new Listener() {
							
							Runnable reflowRunnable = new Runnable() {
								@Override
								public void run() {
									if (!scrolledForm.isDisposed()) {
										scrolledForm.reflow(true);	
									}
								}
							};
							
							@Override
							public void handleEvent(Event event) {
								Display.getDefault().timerExec(50, reflowRunnable);
							}
						});
					} catch (ClassNotFoundException e) {
						StatusManager.getManager().handle(
							new Status(Status.ERROR, IESingleEditorPlugin.PLUGIN_ID, 
								String.format("Can't create %sviewer for '%s' Info Element",
										editable ? "editor " : "",
										configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_IE)),
								e),
							StatusManager.LOG);
					}
			
				}
				
				section.setClient(c);
				
				return section;
			}

	protected IConfigurationElement getConfigurationElementForIE(InfoElement infoElement) throws ClassNotFoundException {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IConfigurationElement[] extensions = registry.getConfigurationElementsFor(
				IESingleEditorPlugin.IEEDIT_EXT_POINT_ID);
		
		for (IConfigurationElement configElement : extensions) {
				String infoElementType = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_IE);
				EClass eClass = infoElement.eClass();
				if (StringUtils.equals(eClass.getInstanceClassName(), infoElementType)) {
					return configElement;
				}
		}
		return null;
	}

	protected abstract IIEDisplayViewer createViewer(Composite parent, ScrolledForm scrolledForm, FormToolkit toolkit,
			InfoElement infoElement, IConfigurationElement configElement) throws ClassNotFoundException;

	protected void cascadeAdapt(Composite composite, FormToolkit toolkit) {
		for (Control control : composite.getChildren()) {
			toolkit.adapt(control, true, true);
			if (control instanceof Composite) {
				Composite childComposite = (Composite) control;
				cascadeAdapt(childComposite, toolkit);
			}
		}
	}

	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}

}