package es.upv.dsic.issi.dplfw.infoelement.singleeditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class IESingleEditorPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "es.upv.dsic.issi.dplfw.infoelements.editorfragments"; //$NON-NLS-1$

	// The editor ID
	public static final String EDITOR_ID = "es.upv.dsic.issi.dplfw.infoelement.singleeditor.SingleInfoElementEditor"; //$NON-NLS-1$
	
	public static final String IMAGE_NO_IMAGE = "IMAGE_NO_IMAGE";

	public static final String IMAGE_REFRESH = "IMAGE_REFRESH";

	public static final String PATH_IMAGE_NO_IMAGE = "/icons/noimage.png";

	public static final String PATH_IMAGE_REFRESH = "/icons/refresh.gif";

	public static final String IEEDIT_EXT_POINT_ID = "es.upv.dsic.issi.dplfw.infoelement.editor";

	public static final String IEEDIT_EXT_POINT_IE = "infoElement";
	
	public static final String IEEDIT_EXT_POINT_EDIT_VIEWER = "editViewer";
	
	public static final String IEEDIT_EXT_POINT_EDIT_DESCRIPTION = "editDescription";

	public static final String IEEDIT_EXT_POINT_DISPLAY_VIEWER = "displayViewer";

	public static final String IEEDIT_EXT_POINT_DISPLAY_DESCRIPTION = "displayDescription";

	public static final String IEEDIT_EXT_POINT_CONTENT_PROVIDER = "contentProvider";
	
	public static final String IEEDIT_EXT_POINT_LABEL_PROVIDER = "labelProvider";

	public static final String IESUBJECT_EXT_POINT_ID = "es.upv.dsic.issi.dplfw.infoelement.editor.iesubjects";

	public static final String IESUBJECT_EXT_POINT_DOMAIN_NAME = "name";

	public static final String IESUBJECT_EXT_POINT_SUBJECT = "Subject";
	
	public static final String IESUBJECT_EXT_POINT_SUBJECT_NAME = "name";

	public static final String IESUBJECTS_SEPARATOR = "\t";

	
	
	// The shared instance
	private static IESingleEditorPlugin plugin;
	
	/**
	 * The constructor
	 */
	public IESingleEditorPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static IESingleEditorPlugin getDefault() {
		return plugin;
	}

	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);
		reg.put(IMAGE_NO_IMAGE, ImageDescriptor.createFromFile(getClass(), PATH_IMAGE_NO_IMAGE));
		reg.put(IMAGE_REFRESH, ImageDescriptor.createFromFile(getClass(), PATH_IMAGE_REFRESH));
	}
}
