package es.upv.dsic.issi.dplfw.fama;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

import es.us.isa.FAMA.Reasoner.QuestionTrader;

public class FamaDplfwBridePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "es.upv.dsic.issi.dplfw.fama"; //$NON-NLS-1$

	// The shared instance
	private static FamaDplfwBridePlugin plugin;

	
	private ServiceReference<?> sr;

	private QuestionTrader qt;
	
	
	/**
	 * The constructor
	 */
	public FamaDplfwBridePlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		
		// We force-load all the FAMA bundles
		es.us.isa.Choco.osgi.Activator.class.getClass();
		es.us.isa.FAMA.models.FAMAAttributed.osgi.Activator.class.getClass();
		es.us.isa.FAMA.models.FAMAfeatureModel.osgi.Activator.class.getClass();
		es.us.isa.JaCoP.osgi.Activator.class.getClass();
		es.us.isa.JavaBDDReasoner.osgi.Activator.class.getClass();
		es.us.isa.Sat4jReasoner.osgi.Activator.class.getClass();
		es.us.isa.FAMA.osgi.activator.Activator.class.getClass();
		
		
		String className = QuestionTrader.class.getCanonicalName();
		//attribute sr (ServiceReference) defined on the Activator
		sr = context.getServiceReference(className);
		qt = (QuestionTrader) context.getService(sr);
	}
	
	public QuestionTrader getQuestionTrader() {
		return qt;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		if (sr != null){
			context.ungetService(sr);
		}
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static FamaDplfwBridePlugin getDefault() {
		return plugin;
	}
}
