/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfmconf.util;

import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfmconf.Criterion;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfFactory;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection;
import es.upv.dsic.issi.dplfw.dfmconf.RequiresSelection;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SelectionBuilder {
    private Map<DocumentFeature, DocumentFeatureSelection> mappings = new HashMap<DocumentFeature, DocumentFeatureSelection>();
    private DocumentFeatureModel dfm;

    public SelectionBuilder(DocumentFeatureModel dfm) {
        this.dfm = dfm;
    }

    public DocumentFeatureModelConfiguration build(DocumentFeatureModelConfiguration dfmc) {
        for (DocumentFeature feature : this.dfm.getFeatures()) {
            DocumentFeatureSelection featureSel = this.getDocFeatureSelFor(feature);
            featureSel.setModelOwner(dfmc);
            if (featureSel.mustBeSelected().booleanValue()) {
                featureSel.setSelected(true);
            }
            this.fillAttributes(feature, featureSel);
        }
        for (DocumentFeatureSelection featureSelection : dfmc.getTopFeaturesSelection()) {
            this.fillChilds(featureSelection);
        }
        if (!this.dfm.getGlobalVariableAttribute().isEmpty()) {
            for (VariableAttribute attr : this.dfm.getGlobalVariableAttribute()) {
                VariableAttributeConfiguration attrConf = DfmconfFactory.eINSTANCE.createVariableAttributeConfiguration();
                for (Reference ref : attr.getReferences()) {
                    es.upv.dsic.issi.dplfw.dfmconf.Reference refConf = DfmconfFactory.eINSTANCE.createReference();
                    refConf.setInfoElementURI(ref.getInfoElementURI());
                    refConf.setReferenceName(ref.getReferenceName());
                    attrConf.getReferences().add((Object)refConf);
                }
                attrConf.setAttribute((Attribute)attr);
                attrConf.setType(attr.getType());
                dfmc.getGlobalVariableAttributes().add((Object)attrConf);
            }
        }
        return dfmc;
    }

    private void fillChilds(DocumentFeatureSelection parentFeatureSel) {
        DocumentFeature documentFeature = parentFeatureSel.getDocumentFeature();
        ArrayList children = new ArrayList();
        if (documentFeature instanceof ContentDocumentFeature) {
            children.addAll(((ContentDocumentFeature)documentFeature).getChildren());
        }
        if (documentFeature instanceof TechnologyDocumentFeature) {
            children.addAll(((TechnologyDocumentFeature)documentFeature).getChildren());
        }
        for (DocumentFeature child : children) {
            DocumentFeatureSelection childFeatureSel = this.getDocFeatureSelFor(child);
            childFeatureSel.setParentSelection(parentFeatureSel);
            if (childFeatureSel.mustBeSelected().booleanValue()) {
                childFeatureSel.setSelected(true);
            }
            this.fillAttributes(child, childFeatureSel);
            this.fillChilds(childFeatureSel);
            parentFeatureSel.getChildrenSelection().add((Object)childFeatureSel);
        }
    }

    private DocumentFeatureSelection getDocFeatureSelFor(DocumentFeature documentFeature) {
        DocumentFeatureSelection featureSelection = this.mappings.get(documentFeature);
        if (featureSelection == null) {
            featureSelection = DfmconfFactory.eINSTANCE.createDocumentFeatureSelection();
            ((DocumentFeatureSelectionImpl)featureSelection).setDocumentFeature(documentFeature);
            this.mappings.put(documentFeature, featureSelection);
            this.fillConstraints(featureSelection);
        }
        return featureSelection;
    }

    private void fillConstraints(DocumentFeatureSelection featureSel) {
        DocumentFeature documentFeature = featureSel.getDocumentFeature();
        if (documentFeature != null) {
            for (RequiresFeature requiresFeature : documentFeature.getRequires()) {
                RequiresSelection requiresSelection = DfmconfFactory.eINSTANCE.createRequiresSelection();
                requiresSelection.setRequiresFeature(requiresFeature);
                featureSel.getRequires().add((Object)requiresSelection);
                for (DocumentFeature candidate : requiresFeature.getCandidates()) {
                    requiresSelection.getCandidates().add((Object)this.getDocFeatureSelFor(candidate));
                }
            }
            for (ExcludesFeature excludesFeature : documentFeature.getExcludes()) {
                ExcludesSelection excludesSelection = DfmconfFactory.eINSTANCE.createExcludesSelection();
                excludesSelection.setExcludesFeature(excludesFeature);
                featureSel.getExcludes().add((Object)excludesSelection);
                for (DocumentFeature candidate : excludesFeature.getCandidates()) {
                    excludesSelection.getCandidates().add((Object)this.getDocFeatureSelFor(candidate));
                }
            }
        }
    }

    private void fillAttributes(DocumentFeature feature, DocumentFeatureSelection featureSel) {
        if (feature instanceof ContentDocumentFeature) {
            for (Attribute attr : ((ContentDocumentFeature)feature).getVariableAttributes()) {
                VariableAttributeConfiguration attrConf = DfmconfFactory.eINSTANCE.createVariableAttributeConfiguration();
                attrConf.setAttribute(attr);
                attrConf.setType(((VariableAttribute)attr).getType());
                for (Reference ref : ((VariableAttribute)attr).getReferences()) {
                    es.upv.dsic.issi.dplfw.dfmconf.Reference refConf = DfmconfFactory.eINSTANCE.createReference();
                    refConf.setInfoElementURI(ref.getInfoElementURI());
                    refConf.setReferenceName(ref.getReferenceName());
                    attrConf.getReferences().add((Object)refConf);
                }
                featureSel.getVariableAttributesConfiguration().add((Object)attrConf);
            }
            CriterionAttribute cAttr = ((ContentDocumentFeature)feature).getSearchCriterion();
            if (cAttr != null) {
                CriterionAttributeConfiguration cAttrConf = DfmconfFactory.eINSTANCE.createCriterionAttributeConfiguration();
                cAttrConf.setAttribute((Attribute)cAttr);
                for (es.upv.dsic.issi.dplfw.dfm.Criterion c : ((ContentDocumentFeature)feature).getSearchCriterion().getCriteria()) {
                    Criterion dfmconfCriterion = DfmconfFactory.eINSTANCE.createCriterion();
                    dfmconfCriterion.setMetadataElement(c.getMetadataElement());
                    if (c.getValue() != null) {
                        dfmconfCriterion.setValue(c.getValue());
                    }
                    cAttrConf.getCriteria().add((Object)dfmconfCriterion);
                }
                featureSel.setCriterionAttributesConfiguration(cAttrConf);
            }
        }
    }
}

