/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfmconf.constraints;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

public class MandatoryConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eventType = context.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eventType == EMFEventType.NULL) {
            if (eObject instanceof DocumentFeatureSelection) {
                DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)eObject;
                statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
            }
        } else {
            Object newValue = context.getFeatureNewValue();
            DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)context.getTarget();
            if (newValue != Boolean.TRUE) {
                statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
            }
        }
        if (statuses != null && !statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)context, statuses);
        }
        return context.createSuccessStatus();
    }

    protected List<IStatus> validateDocumentFeatureSelection(IValidationContext context, DocumentFeatureSelection documentFeatureSelection) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (documentFeatureSelection.getSelected() != Boolean.TRUE && documentFeatureSelection.getDocumentFeature().getType().equals((Object)FeatureType.MANDATORY) && (documentFeatureSelection.getParentSelection() == null || documentFeatureSelection.getParentSelection().getSelected() == Boolean.TRUE)) {
            statuses.add((IStatus)this.buildErrorStatus(context, documentFeatureSelection));
        }
        return statuses;
    }

    protected ConstraintStatus buildErrorStatus(IValidationContext context, DocumentFeatureSelection featureSelection) {
        return ConstraintStatus.createStatus((IValidationContext)context, (EObject)featureSelection, null, (String)"Feature \"{0}\" is mandatory and must be selected", (Object[])new Object[]{featureSelection.getDocumentFeature().getVisibleName()});
    }
}

