/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfmconf.constraints;

import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ExcludesConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eventType = context.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eventType == EMFEventType.NULL) {
            if (eObject instanceof DocumentFeatureSelection) {
                DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)eObject;
                statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
            }
        } else {
            DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)context.getTarget();
            statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
        }
        if (statuses != null && !statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)context, statuses);
        }
        return context.createSuccessStatus();
    }

    protected List<List<DocumentFeatureSelection>> getExclusions(DocumentFeatureSelection documentFeatureSelection) {
        ArrayList<List<DocumentFeatureSelection>> exclusions = new ArrayList<List<DocumentFeatureSelection>>();
        for (ExcludesSelection excludesSelection : documentFeatureSelection.getExcludes()) {
            ArrayList<DocumentFeatureSelection> candidates = new ArrayList<DocumentFeatureSelection>();
            candidates.addAll((Collection<DocumentFeatureSelection>)excludesSelection.getCandidates());
            exclusions.add(candidates);
        }
        return exclusions;
    }

    protected List<IStatus> validateDocumentFeatureSelection(IValidationContext context, DocumentFeatureSelection documentFeatureSelection) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        List<List<DocumentFeatureSelection>> exclusions = this.getExclusions(documentFeatureSelection);
        ArrayList<List<DocumentFeatureSelection>> unmetExclusions = new ArrayList<List<DocumentFeatureSelection>>();
        if (documentFeatureSelection.getSelected() == Boolean.TRUE && !exclusions.isEmpty()) {
            boolean allUnSelected = true;
            for (List<DocumentFeatureSelection> candidates : exclusions) {
                boolean selectedCandidate = false;
                ArrayList<DocumentFeatureSelection> unmetCandidates = new ArrayList<DocumentFeatureSelection>();
                for (DocumentFeatureSelection selection : candidates) {
                    if (selection.getSelected() != Boolean.TRUE) continue;
                    selectedCandidate = true;
                    unmetCandidates.add(selection);
                }
                if (!selectedCandidate) continue;
                allUnSelected = false;
                unmetExclusions.add(unmetCandidates);
            }
            if (!allUnSelected) {
                statuses.add(this.buildErrorStatus(context, documentFeatureSelection, unmetExclusions));
            }
        }
        return statuses;
    }

    protected IStatus buildErrorStatus(IValidationContext context, DocumentFeatureSelection featureSelection, List<List<DocumentFeatureSelection>> requirements) {
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(context.getCurrentConstraintId());
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        for (List<DocumentFeatureSelection> candidates : requirements) {
            StringBuilder builder = new StringBuilder();
            String separator = " or ";
            for (DocumentFeatureSelection selection : candidates) {
                builder.append("\"");
                builder.append(selection.getDocumentFeature().getVisibleName());
                builder.append("\"");
                builder.append(separator);
            }
            builder.setLength(builder.length() - separator.length());
            statuses.add(ConstraintStatus.createStatus((IValidationContext)context, (EObject)featureSelection, candidates, (int)2, (int)desc.getStatusCode(), (String)"{0} {1} excluded by \"{2}\"", (Object[])new Object[]{builder.toString(), candidates.size() > 1 ? "are" : "is", featureSelection.getDocumentFeature().getVisibleName()}));
        }
        statuses.add(ConstraintStatus.createStatus((IValidationContext)context, (EObject)featureSelection, null, (String)"Exclusions of feature\"{0}\" are not met", (Object[])new Object[]{featureSelection.getDocumentFeature().getVisibleName()}));
        IStatus resultStatus = ConstraintStatus.createMultiStatus((IValidationContext)context, statuses);
        return resultStatus;
    }
}

