/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.dfmconf.constraints;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

public class AlternativeGroupConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext context) {
        EObject eObject = context.getTarget();
        EMFEventType eventType = context.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eventType == EMFEventType.NULL) {
            if (eObject instanceof DocumentFeatureSelection) {
                DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)eObject;
                statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
            }
        } else {
            DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection)context.getTarget();
            statuses.addAll(this.validateDocumentFeatureSelection(context, documentFeatureSelection));
        }
        if (statuses != null && !statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)context, statuses);
        }
        return context.createSuccessStatus();
    }

    protected List<DocumentFeatureSelection> getAlternativeChilds(DocumentFeatureSelection documentFeatureSelection) {
        ArrayList<DocumentFeatureSelection> selections = new ArrayList<DocumentFeatureSelection>();
        for (DocumentFeatureSelection selection : documentFeatureSelection.getChildrenSelection()) {
            if (!selection.getDocumentFeature().getType().equals((Object)FeatureType.ALTERNATIVE)) continue;
            selections.add(selection);
        }
        return selections;
    }

    protected List<IStatus> validateDocumentFeatureSelection(IValidationContext context, DocumentFeatureSelection documentFeatureSelection) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        List<DocumentFeatureSelection> alternatives = this.getAlternativeChilds(documentFeatureSelection);
        if (documentFeatureSelection.getSelected() == Boolean.TRUE && !alternatives.isEmpty()) {
            boolean noneSelected = true;
            for (DocumentFeatureSelection selection : alternatives) {
                if (selection.getSelected() != Boolean.TRUE) continue;
                noneSelected = false;
                break;
            }
            if (noneSelected) {
                statuses.add((IStatus)this.buildErrorStatus(context, documentFeatureSelection));
            }
        }
        return statuses;
    }

    protected ConstraintStatus buildErrorStatus(IValidationContext context, DocumentFeatureSelection featureSelection) {
        return ConstraintStatus.createStatus((IValidationContext)context, (EObject)featureSelection, null, (String)"No alternative has been selected in \"{0}\" group", (Object[])new Object[]{featureSelection.getDocumentFeature().getVisibleName()});
    }
}

