package es.upv.dsic.issi.dplfw.dfmconf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.CriterionAttribute;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.ExcludesFeature;
import es.upv.dsic.issi.dplfw.dfm.RequiresFeature;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.VariableAttribute;
import es.upv.dsic.issi.dplfw.dfmconf.Criterion;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfFactory;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection;
import es.upv.dsic.issi.dplfw.dfmconf.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.RequiresSelection;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl;

public class SelectionBuilder {
	
	private Map<DocumentFeature, DocumentFeatureSelection> mappings = new HashMap<DocumentFeature, DocumentFeatureSelection>();
	
	private DocumentFeatureModel dfm;
	
	public SelectionBuilder(DocumentFeatureModel dfm) {
		this.dfm = dfm;
	}
	
	public DocumentFeatureModelConfiguration build(DocumentFeatureModelConfiguration dfmc) {
		
		// Root elements
		for (DocumentFeature feature : dfm.getFeatures()) {
			DocumentFeatureSelection featureSel = getDocFeatureSelFor(feature);
			featureSel.setModelOwner(dfmc);
			// Mandatory root features must be always selected
			if (featureSel.mustBeSelected()) {
				featureSel.setSelected(true);
			}
			
			fillAttributes(feature, featureSel);
			
		}
		
		
		// Child elements
		for (DocumentFeatureSelection featureSelection : dfmc.getTopFeaturesSelection()) {
			fillChilds(featureSelection);
		}
		
		// Global Attributes
		if(!dfm.getGlobalVariableAttribute().isEmpty()){
			for(VariableAttribute attr : dfm.getGlobalVariableAttribute()){
				VariableAttributeConfiguration attrConf =  DfmconfFactory.eINSTANCE.createVariableAttributeConfiguration();

				for(es.upv.dsic.issi.dplfw.dfm.Reference ref : ((VariableAttribute) attr).getReferences()){
					Reference refConf = DfmconfFactory.eINSTANCE.createReference();
					refConf.setInfoElementURI(ref.getInfoElementURI());
					refConf.setReferenceName(ref.getReferenceName());
					attrConf.getReferences().add(refConf);
				}
				attrConf.setAttribute(attr);
				attrConf.setType(attr.getType());
				dfmc.getGlobalVariableAttributes().add(attrConf);
			}	
		}
		
		return dfmc;
	}
	
	private void fillChilds(DocumentFeatureSelection parentFeatureSel) {

		DocumentFeature documentFeature = parentFeatureSel.getDocumentFeature();

		List<DocumentFeature> children = new ArrayList<DocumentFeature>();

		if (documentFeature instanceof ContentDocumentFeature) {
			children.addAll(((ContentDocumentFeature) documentFeature).getChildren());
		}
		
		if (documentFeature instanceof TechnologyDocumentFeature) {
			children.addAll(((TechnologyDocumentFeature) documentFeature).getChildren());
		}

		DocumentFeatureSelection childFeatureSel;
		for (DocumentFeature child : children) {
			childFeatureSel = getDocFeatureSelFor(child);
			childFeatureSel.setParentSelection(parentFeatureSel);
			if (childFeatureSel.mustBeSelected()) {
				childFeatureSel.setSelected(true);
			}
			
			fillAttributes(child, childFeatureSel);

			
			fillChilds(childFeatureSel);
			parentFeatureSel.getChildrenSelection().add(childFeatureSel);
		}
	}
	
	private DocumentFeatureSelection getDocFeatureSelFor(DocumentFeature documentFeature) {
		DocumentFeatureSelection featureSelection = mappings.get(documentFeature);
		if (featureSelection == null) {		
			featureSelection = DfmconfFactory.eINSTANCE.createDocumentFeatureSelection();
			((DocumentFeatureSelectionImpl) featureSelection).setDocumentFeature(documentFeature);
			mappings.put(documentFeature, featureSelection);
			fillConstraints(featureSelection);
		}
		return featureSelection;
	}
	
	
	private void fillConstraints(DocumentFeatureSelection featureSel) {
		DocumentFeature documentFeature = featureSel.getDocumentFeature();
		if (documentFeature != null) {
			for (RequiresFeature requiresFeature : documentFeature.getRequires()) {
				RequiresSelection requiresSelection = DfmconfFactory.eINSTANCE.createRequiresSelection();
				requiresSelection.setRequiresFeature(requiresFeature);
				featureSel.getRequires().add(requiresSelection);
				for (DocumentFeature candidate : requiresFeature.getCandidates()) {
					requiresSelection.getCandidates().add(getDocFeatureSelFor(candidate));
				}
			}
			for (ExcludesFeature excludesFeature : documentFeature.getExcludes()) {
				ExcludesSelection excludesSelection = DfmconfFactory.eINSTANCE.createExcludesSelection();
				excludesSelection.setExcludesFeature(excludesFeature);
				featureSel.getExcludes().add(excludesSelection);
				for (DocumentFeature candidate : excludesFeature.getCandidates()) {
					excludesSelection.getCandidates().add(getDocFeatureSelFor(candidate));
				}
			}
		}
	}
	
	private void fillAttributes(DocumentFeature feature, DocumentFeatureSelection featureSel){
		
		if(feature instanceof ContentDocumentFeature){
			for(Attribute attr : ((ContentDocumentFeature) feature).getVariableAttributes()){
					VariableAttributeConfiguration attrConf =  DfmconfFactory.eINSTANCE.createVariableAttributeConfiguration();
					attrConf.setAttribute(attr);
					attrConf.setType(((VariableAttribute) attr).getType());
					for(es.upv.dsic.issi.dplfw.dfm.Reference ref : ((VariableAttribute) attr).getReferences()){
						Reference refConf = DfmconfFactory.eINSTANCE.createReference();
						refConf.setInfoElementURI(ref.getInfoElementURI());
						refConf.setReferenceName(ref.getReferenceName());
						attrConf.getReferences().add(refConf);
					}
					featureSel.getVariableAttributesConfiguration().add(attrConf);
			}		
			CriterionAttribute cAttr = ((ContentDocumentFeature) feature).getSearchCriterion();
			if(cAttr != null){
				CriterionAttributeConfiguration cAttrConf =  DfmconfFactory.eINSTANCE.createCriterionAttributeConfiguration();
				cAttrConf.setAttribute(cAttr);
				for(es.upv.dsic.issi.dplfw.dfm.Criterion c : ((ContentDocumentFeature) feature).getSearchCriterion().getCriteria()){
					Criterion dfmconfCriterion = DfmconfFactory.eINSTANCE.createCriterion();
					dfmconfCriterion.setMetadataElement(c.getMetadataElement());
					if(c.getValue() != null){
						dfmconfCriterion.setValue(c.getValue());	
					}
					cAttrConf.getCriteria().add(dfmconfCriterion);
				}
				featureSel.setCriterionAttributesConfiguration(cAttrConf);
			}			
		}	
	}
	
}