/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection;
import es.upv.dsic.issi.dplfw.dfmconf.RequiresSelection;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Feature Selection</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getDocumentFeature <em>Document Feature</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getChildrenSelection <em>Children Selection</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getParentSelection <em>Parent Selection</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getSelected <em>Selected</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getModelOwner <em>Model Owner</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getRequires <em>Requires</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getExcludes <em>Excludes</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getIsRequiredBy <em>Is Required By</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getIsExcludedBy <em>Is Excluded By</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getVariableAttributesConfiguration <em>Variable Attributes Configuration</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureSelectionImpl#getCriterionAttributesConfiguration <em>Criterion Attributes Configuration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DocumentFeatureSelectionImpl extends EObjectImpl implements DocumentFeatureSelection {
	/**
	 * The cached value of the '{@link #getDocumentFeature() <em>Document Feature</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentFeature()
	 * @generated
	 * @ordered
	 */
	protected DocumentFeature documentFeature;

	/**
	 * The cached value of the '{@link #getChildrenSelection() <em>Children Selection</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildrenSelection()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentFeatureSelection> childrenSelection;

	/**
	 * The default value of the '{@link #getSelected() <em>Selected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelected()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean SELECTED_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSelected() <em>Selected</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelected()
	 * @generated
	 * @ordered
	 */
	protected Boolean selected = SELECTED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRequires() <em>Requires</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequires()
	 * @generated
	 * @ordered
	 */
	protected EList<RequiresSelection> requires;

	/**
	 * The cached value of the '{@link #getExcludes() <em>Excludes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExcludes()
	 * @generated
	 * @ordered
	 */
	protected EList<ExcludesSelection> excludes;

	/**
	 * The cached value of the '{@link #getIsRequiredBy() <em>Is Required By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsRequiredBy()
	 * @generated
	 * @ordered
	 */
	protected EList<RequiresSelection> isRequiredBy;

	/**
	 * The cached value of the '{@link #getIsExcludedBy() <em>Is Excluded By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsExcludedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<ExcludesSelection> isExcludedBy;

	/**
	 * The cached value of the '{@link #getVariableAttributesConfiguration() <em>Variable Attributes Configuration</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariableAttributesConfiguration()
	 * @generated
	 * @ordered
	 */
	protected EList<VariableAttributeConfiguration> variableAttributesConfiguration;

	/**
	 * The cached value of the '{@link #getCriterionAttributesConfiguration() <em>Criterion Attributes Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCriterionAttributesConfiguration()
	 * @generated
	 * @ordered
	 */
	protected CriterionAttributeConfiguration criterionAttributesConfiguration;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureSelectionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DfmconfPackage.Literals.DOCUMENT_FEATURE_SELECTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentFeature getDocumentFeature() {
		if (documentFeature != null && documentFeature.eIsProxy()) {
			InternalEObject oldDocumentFeature = (InternalEObject)documentFeature;
			documentFeature = (DocumentFeature)eResolveProxy(oldDocumentFeature);
			if (documentFeature != oldDocumentFeature) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE, oldDocumentFeature, documentFeature));
			}
		}
		return documentFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentFeature basicGetDocumentFeature() {
		return documentFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDocumentFeature(DocumentFeature newDocumentFeature) {
		DocumentFeature oldDocumentFeature = documentFeature;
		documentFeature = newDocumentFeature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE, oldDocumentFeature, documentFeature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentFeatureSelection> getChildrenSelection() {
		if (childrenSelection == null) {
			childrenSelection = new EObjectContainmentWithInverseEList<DocumentFeatureSelection>(DocumentFeatureSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION);
		}
		return childrenSelection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentFeatureSelection getParentSelection() {
		if (eContainerFeatureID() != DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION) return null;
		return (DocumentFeatureSelection)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParentSelection(DocumentFeatureSelection newParentSelection, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newParentSelection, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentSelection(DocumentFeatureSelection newParentSelection) {
		if (newParentSelection != eInternalContainer() || (eContainerFeatureID() != DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION && newParentSelection != null)) {
			if (EcoreUtil.isAncestor(this, newParentSelection))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParentSelection != null)
				msgs = ((InternalEObject)newParentSelection).eInverseAdd(this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION, DocumentFeatureSelection.class, msgs);
			msgs = basicSetParentSelection(newParentSelection, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION, newParentSelection, newParentSelection));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Boolean getSelected() {
		return selected;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void setSelected(Boolean newSelected) {
		Boolean oldSelected = selected;
		selected = newSelected;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED, oldSelected, selected));
		
		if (newSelected == Boolean.TRUE) {
			// Select the parent if it is not already selected
			if (getParentSelection() != null && getParentSelection().getSelected() != Boolean.TRUE) {
				getParentSelection().setSelected(Boolean.TRUE);
			}
			// Select children which must be selected
			for (DocumentFeatureSelection child : getChildrenSelection()) {
				if (child.mustBeSelected())
					child.setSelected(true);
			}
		} else {
			// Unselect all childrens
			for (DocumentFeatureSelection child : getChildrenSelection()) {
				child.setSelected(null);
			}			
		}
		
		if (getDocumentFeature() == null)
			return;
		
		if (getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE) && newSelected == null)
			unselectChildSiblings(this);
		if (getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE) && newSelected == Boolean.TRUE)
			disableChildSiblings(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentFeatureModelConfiguration getModelOwner() {
		if (eContainerFeatureID() != DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER) return null;
		return (DocumentFeatureModelConfiguration)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModelOwner(DocumentFeatureModelConfiguration newModelOwner, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModelOwner, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModelOwner(DocumentFeatureModelConfiguration newModelOwner) {
		if (newModelOwner != eInternalContainer() || (eContainerFeatureID() != DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER && newModelOwner != null)) {
			if (EcoreUtil.isAncestor(this, newModelOwner))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModelOwner != null)
				msgs = ((InternalEObject)newModelOwner).eInverseAdd(this, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION, DocumentFeatureModelConfiguration.class, msgs);
			msgs = basicSetModelOwner(newModelOwner, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER, newModelOwner, newModelOwner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RequiresSelection> getRequires() {
		if (requires == null) {
			requires = new EObjectContainmentWithInverseEList<RequiresSelection>(RequiresSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES, DfmconfPackage.REQUIRES_SELECTION__OWNER_SELECTION);
		}
		return requires;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ExcludesSelection> getExcludes() {
		if (excludes == null) {
			excludes = new EObjectContainmentWithInverseEList<ExcludesSelection>(ExcludesSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES, DfmconfPackage.EXCLUDES_SELECTION__OWNER_SELECTION);
		}
		return excludes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RequiresSelection> getIsRequiredBy() {
		if (isRequiredBy == null) {
			isRequiredBy = new EObjectWithInverseResolvingEList.ManyInverse<RequiresSelection>(RequiresSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY, DfmconfPackage.REQUIRES_SELECTION__CANDIDATES);
		}
		return isRequiredBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ExcludesSelection> getIsExcludedBy() {
		if (isExcludedBy == null) {
			isExcludedBy = new EObjectWithInverseResolvingEList.ManyInverse<ExcludesSelection>(ExcludesSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY, DfmconfPackage.EXCLUDES_SELECTION__CANDIDATES);
		}
		return isExcludedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VariableAttributeConfiguration> getVariableAttributesConfiguration() {
		if (variableAttributesConfiguration == null) {
			variableAttributesConfiguration = new EObjectContainmentEList<VariableAttributeConfiguration>(VariableAttributeConfiguration.class, this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION);
		}
		return variableAttributesConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CriterionAttributeConfiguration getCriterionAttributesConfiguration() {
		return criterionAttributesConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCriterionAttributesConfiguration(CriterionAttributeConfiguration newCriterionAttributesConfiguration, NotificationChain msgs) {
		CriterionAttributeConfiguration oldCriterionAttributesConfiguration = criterionAttributesConfiguration;
		criterionAttributesConfiguration = newCriterionAttributesConfiguration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION, oldCriterionAttributesConfiguration, newCriterionAttributesConfiguration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCriterionAttributesConfiguration(CriterionAttributeConfiguration newCriterionAttributesConfiguration) {
		if (newCriterionAttributesConfiguration != criterionAttributesConfiguration) {
			NotificationChain msgs = null;
			if (criterionAttributesConfiguration != null)
				msgs = ((InternalEObject)criterionAttributesConfiguration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION, null, msgs);
			if (newCriterionAttributesConfiguration != null)
				msgs = ((InternalEObject)newCriterionAttributesConfiguration).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION, null, msgs);
			msgs = basicSetCriterionAttributesConfiguration(newCriterionAttributesConfiguration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION, newCriterionAttributesConfiguration, newCriterionAttributesConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public Boolean mustBeSelected() {
		if (getModelOwner() != null && getDocumentFeature() != null
				&& getDocumentFeature().getType().equals(FeatureType.MANDATORY)) { 
			// Feature is a root feature and MANDATORY
			return true;
		} else if (getParentSelection() != null && getParentSelection().getSelected() == Boolean.TRUE
				&& getDocumentFeature() != null && getDocumentFeature().getType().equals(FeatureType.MANDATORY)) {
			// Feature is a child feature of a selected feature and is MANDATORY
			return true;
		} else {
			return false;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public Boolean canBeSelected() {
		
//		boolean parentSelected = getParentSelection() != null ? getParentSelection().isSelected() : // parent is selected
//									getModelOwner() != null ? true : false;							// is root feature
//
//		// If parent is not selected feature can't be selected 
//		if (!parentSelected)
//			return false;

		// If feature is part of an XOR group, and another feature is selected, it can't be selected
		// Three cases must be treated:
		{
			if (getModelOwner() != null) {
				// 1. Feature is a CONTENT root feature
				for (DocumentFeatureSelection featureSel : getModelOwner().getTopFeaturesSelection()) {
					if (featureSel != this && 
							featureSel.getDocumentFeature() instanceof ContentDocumentFeature &&
							featureSel.getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE) &&
							featureSel.getSelected() == Boolean.TRUE) {
						return false;
					}
				}
				// 2. Feature is a TECHNOLOGY root feature
				for (DocumentFeatureSelection featureSel : getModelOwner().getTopFeaturesSelection()) {
					if (featureSel != this && 
							featureSel.getDocumentFeature() instanceof TechnologyDocumentFeature &&
							featureSel.getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE) &&
							featureSel.getSelected() == Boolean.TRUE) {
						return false;
					}
				}
			}
		}
		{
			// 3. Feature is a child feature of another feature. It is guaranteed that 
			// all the child features are of the same type.
			if (getParentSelection() != null) {
				for (DocumentFeatureSelection featureSel : getParentSelection().getChildrenSelection()) {
					if (featureSel != this && 
							featureSel.getDocumentFeature().getType().equals(FeatureType.ALTERNATIVE) &&
							featureSel.getSelected() == Boolean.TRUE) {
						return false;
					}
				}
			}
		}

		
		return true;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void disableChildSiblings(DocumentFeatureSelection child) {

		List<DocumentFeatureSelection> siblings = null;
		
		// Regular features
		if (getParentSelection() != null) {
			// Collect the siblings
			siblings = new ArrayList<DocumentFeatureSelection>();
			for (DocumentFeatureSelection featureSelection : getParentSelection().getChildrenSelection()) {
				if (featureSelection != child &&
						featureSelection.getDocumentFeature().eClass() == child.getDocumentFeature().eClass() &&
						featureSelection.getDocumentFeature().getType() == child.getDocumentFeature().getType())
					siblings.add(featureSelection);
			}
		}

		// Root features
		if (getModelOwner() != null) {
			// Collect the siblings
			siblings = new ArrayList<DocumentFeatureSelection>();
			for (DocumentFeatureSelection featureSelection : getModelOwner().getTopFeaturesSelection()) {
				if (featureSelection != child &&
						featureSelection.getDocumentFeature().eClass() == child.getDocumentFeature().eClass() &&
						featureSelection.getDocumentFeature().getType() == child.getDocumentFeature().getType())
					siblings.add(featureSelection);
			}
		}
		// Disable siblings
		for (DocumentFeatureSelection sibling : siblings) {
			if (sibling.getSelected() != Boolean.FALSE)
				sibling.setSelected(false);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void unselectChildSiblings(DocumentFeatureSelection child)  {

		List<DocumentFeatureSelection> siblings = null;
		
		// Regular features
		if (getParentSelection() != null) {
			// Collect the siblings
			siblings = new ArrayList<DocumentFeatureSelection>();
			for (DocumentFeatureSelection featureSelection : getParentSelection().getChildrenSelection()) {
				if (featureSelection.getDocumentFeature().eClass() == child.getDocumentFeature().eClass() &&
						featureSelection.getDocumentFeature().getType() == child.getDocumentFeature().getType())
					siblings.add(featureSelection);
			}
		}

		// Root features
		if (getModelOwner() != null) {
			// Collect the siblings
			siblings = new ArrayList<DocumentFeatureSelection>();
			for (DocumentFeatureSelection featureSelection : getModelOwner().getTopFeaturesSelection()) {
				if (featureSelection.getDocumentFeature().eClass() == child.getDocumentFeature().eClass() &&
						featureSelection.getDocumentFeature().getType() == child.getDocumentFeature().getType())
					siblings.add(featureSelection);
			}
		}
		if (siblings != null) {
			// Unset siblings
			for (DocumentFeatureSelection sibling : siblings) {
				if (sibling.getSelected() != null)
					sibling.setSelected(null);
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildrenSelection()).basicAdd(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetParentSelection((DocumentFeatureSelection)otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModelOwner((DocumentFeatureModelConfiguration)otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRequires()).basicAdd(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getExcludes()).basicAdd(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsRequiredBy()).basicAdd(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsExcludedBy()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				return ((InternalEList<?>)getChildrenSelection()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				return basicSetParentSelection(null, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				return basicSetModelOwner(null, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				return ((InternalEList<?>)getRequires()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				return ((InternalEList<?>)getExcludes()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				return ((InternalEList<?>)getIsRequiredBy()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				return ((InternalEList<?>)getIsExcludedBy()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
				return ((InternalEList<?>)getVariableAttributesConfiguration()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				return basicSetCriterionAttributesConfiguration(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				return eInternalContainer().eInverseRemove(this, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION, DocumentFeatureSelection.class, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				return eInternalContainer().eInverseRemove(this, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION, DocumentFeatureModelConfiguration.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE:
				if (resolve) return getDocumentFeature();
				return basicGetDocumentFeature();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				return getChildrenSelection();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				return getParentSelection();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED:
				return getSelected();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				return getModelOwner();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				return getRequires();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				return getExcludes();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				return getIsRequiredBy();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				return getIsExcludedBy();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
				return getVariableAttributesConfiguration();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				return getCriterionAttributesConfiguration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE:
				setDocumentFeature((DocumentFeature)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				getChildrenSelection().clear();
				getChildrenSelection().addAll((Collection<? extends DocumentFeatureSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				setParentSelection((DocumentFeatureSelection)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED:
				setSelected((Boolean)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				setModelOwner((DocumentFeatureModelConfiguration)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				getRequires().clear();
				getRequires().addAll((Collection<? extends RequiresSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				getExcludes().clear();
				getExcludes().addAll((Collection<? extends ExcludesSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				getIsRequiredBy().clear();
				getIsRequiredBy().addAll((Collection<? extends RequiresSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				getIsExcludedBy().clear();
				getIsExcludedBy().addAll((Collection<? extends ExcludesSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
				getVariableAttributesConfiguration().clear();
				getVariableAttributesConfiguration().addAll((Collection<? extends VariableAttributeConfiguration>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				setCriterionAttributesConfiguration((CriterionAttributeConfiguration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE:
				setDocumentFeature((DocumentFeature)null);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				getChildrenSelection().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				setParentSelection((DocumentFeatureSelection)null);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED:
				setSelected(SELECTED_EDEFAULT);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				setModelOwner((DocumentFeatureModelConfiguration)null);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				getRequires().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				getExcludes().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				getIsRequiredBy().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				getIsExcludedBy().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
				getVariableAttributesConfiguration().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				setCriterionAttributesConfiguration((CriterionAttributeConfiguration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__DOCUMENT_FEATURE:
				return documentFeature != null;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CHILDREN_SELECTION:
				return childrenSelection != null && !childrenSelection.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__PARENT_SELECTION:
				return getParentSelection() != null;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__SELECTED:
				return SELECTED_EDEFAULT == null ? selected != null : !SELECTED_EDEFAULT.equals(selected);
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER:
				return getModelOwner() != null;
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__REQUIRES:
				return requires != null && !requires.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__EXCLUDES:
				return excludes != null && !excludes.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_REQUIRED_BY:
				return isRequiredBy != null && !isRequiredBy.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__IS_EXCLUDED_BY:
				return isExcludedBy != null && !isExcludedBy.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__VARIABLE_ATTRIBUTES_CONFIGURATION:
				return variableAttributesConfiguration != null && !variableAttributesConfiguration.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_SELECTION__CRITERION_ATTRIBUTES_CONFIGURATION:
				return criterionAttributesConfiguration != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (selected: ");
		result.append(selected);
		result.append(')');
		return result.toString();
	}

} //DocumentFeatureSelectionImpl
