/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfmconf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.MetadataElement;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;
import es.upv.dsic.issi.dplfw.dfmconf.util.SelectionBuilder;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Feature Model Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureModelConfigurationImpl#getDocumentFeatureModel <em>Document Feature Model</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureModelConfigurationImpl#getTopFeaturesSelection <em>Top Features Selection</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureModelConfigurationImpl#getDocumentFeatureModelURI <em>Document Feature Model URI</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureModelConfigurationImpl#getSelectedContexts <em>Selected Contexts</em>}</li>
 *   <li>{@link es.upv.dsic.issi.dplfw.dfmconf.impl.DocumentFeatureModelConfigurationImpl#getGlobalVariableAttributes <em>Global Variable Attributes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DocumentFeatureModelConfigurationImpl extends EObjectImpl implements DocumentFeatureModelConfiguration {
	/**
	 * The cached value of the '{@link #getDocumentFeatureModel() <em>Document Feature Model</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentFeatureModel()
	 * @generated
	 * @ordered
	 */
	protected DocumentFeatureModel documentFeatureModel;

	/**
	 * The cached value of the '{@link #getTopFeaturesSelection() <em>Top Features Selection</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopFeaturesSelection()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentFeatureSelection> topFeaturesSelection;

	/**
	 * The default value of the '{@link #getDocumentFeatureModelURI() <em>Document Feature Model URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentFeatureModelURI()
	 * @generated
	 * @ordered
	 */
	protected static final URI DOCUMENT_FEATURE_MODEL_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDocumentFeatureModelURI() <em>Document Feature Model URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentFeatureModelURI()
	 * @generated
	 * @ordered
	 */
	protected URI documentFeatureModelURI = DOCUMENT_FEATURE_MODEL_URI_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSelectedContexts() <em>Selected Contexts</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectedContexts()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentContext> selectedContexts;

	/**
	 * The cached value of the '{@link #getGlobalVariableAttributes() <em>Global Variable Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGlobalVariableAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<VariableAttributeConfiguration> globalVariableAttributes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureModelConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DfmconfPackage.Literals.DOCUMENT_FEATURE_MODEL_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentFeatureModel getDocumentFeatureModel() {
		if (documentFeatureModel != null && documentFeatureModel.eIsProxy()) {
			InternalEObject oldDocumentFeatureModel = (InternalEObject)documentFeatureModel;
			documentFeatureModel = (DocumentFeatureModel)eResolveProxy(oldDocumentFeatureModel);
			if (documentFeatureModel != oldDocumentFeatureModel) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL, oldDocumentFeatureModel, documentFeatureModel));
			}
		}
		return documentFeatureModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentFeatureModel basicGetDocumentFeatureModel() {
		return documentFeatureModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDocumentFeatureModel(DocumentFeatureModel newDocumentFeatureModel) {
		DocumentFeatureModel oldDocumentFeatureModel = documentFeatureModel;
		documentFeatureModel = newDocumentFeatureModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL, oldDocumentFeatureModel, documentFeatureModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentFeatureSelection> getTopFeaturesSelection() {
		if (topFeaturesSelection == null) {
			topFeaturesSelection = new EObjectContainmentWithInverseEList<DocumentFeatureSelection>(DocumentFeatureSelection.class, this, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION, DfmconfPackage.DOCUMENT_FEATURE_SELECTION__MODEL_OWNER);
		}
		return topFeaturesSelection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public URI getDocumentFeatureModelURI() {
		return documentFeatureModelURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDocumentFeatureModelURI(URI newDocumentFeatureModelURI) {
		URI oldDocumentFeatureModelURI = documentFeatureModelURI;
		documentFeatureModelURI = newDocumentFeatureModelURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI, oldDocumentFeatureModelURI, documentFeatureModelURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentContext> getSelectedContexts() {
		if (selectedContexts == null) {
			selectedContexts = new EObjectResolvingEList.Unsettable<DocumentContext>(DocumentContext.class, this, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS);
		}
		return selectedContexts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void unsetSelectedContexts() {
		if (selectedContexts != null) ((InternalEList.Unsettable<?>)selectedContexts).unset();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetSelectedContexts() {
		return selectedContexts != null && ((InternalEList.Unsettable<?>)selectedContexts).isSet();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<VariableAttributeConfiguration> getGlobalVariableAttributes() {
		if (globalVariableAttributes == null) {
			globalVariableAttributes = new EObjectContainmentEList<VariableAttributeConfiguration>(VariableAttributeConfiguration.class, this, DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES);
		}
		return globalVariableAttributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void initialize() throws FeatureModelNotFoundException {
		URI uri = getDocumentFeatureModelURI();
		ResourceSet resourceSet = null;
		if (this.eResource() != null && this.eResource().getResourceSet() != null) {
			resourceSet = this.eResource().getResourceSet();
		} else {
			resourceSet = new ResourceSetImpl();
		}
		Resource resource = resourceSet.getResource(uri, true);
		if (resource == null) {
			throw new FeatureModelNotFoundException(this);
		}
		EObject eObject = resource.getContents().get(0);
		if (!(eObject instanceof DocumentFeatureModel)) {
			throw new FeatureModelNotFoundException(this);
		}
		DocumentFeatureModel featureModel = (DocumentFeatureModel) eObject;
		setDocumentFeatureModel(featureModel);
		SelectionBuilder builder = new SelectionBuilder(featureModel);
		builder.build(this);
		resource.unload();
	}

	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public void reconcile() throws FeatureModelNotFoundException {
		class SavedSelection {
			Boolean selected;
			HashMap<String, VariableAttributeConfiguration> vacMap = new HashMap<>();
			String criterionName;
			URI criterionCandidate;
			HashMap<MetadataElement, String> cacMap = new HashMap<>();
		}
		HashMap<URI, SavedSelection> previousSelection = new HashMap<>();
		HashMap<String, VariableAttributeConfiguration> previousGlobalVarAttr = new HashMap<>();
		
		// We collect the actual selection
		for (TreeIterator<EObject> it = this.eAllContents(); it.hasNext();) {
			EObject configElement = it.next();
			if (configElement instanceof DocumentFeatureSelection) {
				DocumentFeatureSelection selection = (DocumentFeatureSelection) configElement;
				if (selection.getDocumentFeature() != null) { // Check that the CDF still exists 
					SavedSelection savedSelection = new SavedSelection();
					savedSelection.selected = selection.getSelected(); 
					selection.getVariableAttributesConfiguration().forEach(vac -> {
						if (vac.getAttribute() != null && vac.getAttribute().getIdName() != null) {
							savedSelection.vacMap.put(vac.getAttribute().getIdName(), vac);
						}
					});
					if (selection.getCriterionAttributesConfiguration() != null 
							&& selection.getCriterionAttributesConfiguration().getAttribute() != null) {
						savedSelection.criterionName = selection.getCriterionAttributesConfiguration().getAttribute().getIdName();
						savedSelection.criterionCandidate = selection.getCriterionAttributesConfiguration().getInfoElementURICandidate();
						selection.getCriterionAttributesConfiguration().getCriteria().forEach(c -> {
							savedSelection.cacMap.put(c.getMetadataElement(), c.getValue());
						});
					}
					previousSelection.put(EcoreUtil.getURI(selection.getDocumentFeature()), savedSelection);
				}
			}
		}
		
		// We collect the global variable attributes
		for (VariableAttributeConfiguration var : getGlobalVariableAttributes()) {
			// Check that the variable is still in the DFM
			if (var.getAttribute() != null && var.getAttribute().getIdName() != null) {
				previousGlobalVarAttr.put(var.getAttribute().getIdName(), var);
			}
		}
		
		// We clear the global variable attributes
		this.getGlobalVariableAttributes().clear();
		
		// We clear the configuration and build a new structure
		this.getTopFeaturesSelection().clear();

		initialize();
		
		// Remove deleted DocumentContexts
		List<DocumentContext> contexts = new ArrayList<DocumentContext>();
		for (DocumentContext context : getSelectedContexts()) {
			if (getDocumentFeatureModel().getContexts().contains(context)) {
				contexts.add(context);
			}
		}
		
		getSelectedContexts().clear();
		getSelectedContexts().addAll(contexts);
		
		// Restore the previous selection
		for (TreeIterator<EObject> it = this.eAllContents(); it.hasNext();) {
			EObject configElement = it.next();
			if (configElement instanceof DocumentFeatureSelection) {
				DocumentFeatureSelection selection = (DocumentFeatureSelection) configElement;
				SavedSelection savedSelection = previousSelection.get(EcoreUtil.getURI(selection.getDocumentFeature()));
				if(savedSelection != null){
					selection.setSelected(savedSelection.selected);
					selection.getVariableAttributesConfiguration().forEach(vac -> {
						if (vac.getAttribute() != null && vac.getAttribute().getIdName() != null) {
							VariableAttributeConfiguration savedVac = savedSelection.vacMap.get(vac.getAttribute().getIdName());
							vac.setType(savedVac.getType());
							vac.setValue(savedVac.getValue());
						}
					});
					if (selection.getCriterionAttributesConfiguration() != null
							&& selection.getCriterionAttributesConfiguration().getAttribute() != null
							&& selection.getCriterionAttributesConfiguration().getAttribute().getIdName() != null
							&& selection.getCriterionAttributesConfiguration().getAttribute().getIdName().equals(savedSelection.criterionName)) {
						selection.getCriterionAttributesConfiguration().setInfoElementURICandidate(savedSelection.criterionCandidate);
						// IMPORTANT:
						// It is not clear the reconciling behavior regarding the Criteria.
						// Should mandate the preiously configured value in the Config?
						// If new Criteria is modified/added/removed, should mandate the modifications in the DFM?
						// Since we're in doubt, we just leave the Criteria defined in the DFM
//						selection.getCriterionAttributesConfiguration().getCriteria().forEach( c -> {
//							c.setValue(savedSelection.cacMap.get(c.getMetadataElement())); 
//						});
					}
				}				
			}
		}
		
		for (VariableAttributeConfiguration var : getGlobalVariableAttributes()) {
			if (var.getAttribute() != null && var.getAttribute().getIdName() != null) {
				VariableAttributeConfiguration prevVarConf = previousGlobalVarAttr.get(var.getAttribute().getIdName());
				if(prevVarConf != null){
					var.setType(prevVarConf.getType());
					var.setValue(prevVarConf.getValue());
				}
			}
		}
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTopFeaturesSelection()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				return ((InternalEList<?>)getTopFeaturesSelection()).basicRemove(otherEnd, msgs);
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				return ((InternalEList<?>)getGlobalVariableAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL:
				if (resolve) return getDocumentFeatureModel();
				return basicGetDocumentFeatureModel();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				return getTopFeaturesSelection();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI:
				return getDocumentFeatureModelURI();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS:
				return getSelectedContexts();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				return getGlobalVariableAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL:
				setDocumentFeatureModel((DocumentFeatureModel)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				getTopFeaturesSelection().clear();
				getTopFeaturesSelection().addAll((Collection<? extends DocumentFeatureSelection>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI:
				setDocumentFeatureModelURI((URI)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS:
				getSelectedContexts().clear();
				getSelectedContexts().addAll((Collection<? extends DocumentContext>)newValue);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				getGlobalVariableAttributes().clear();
				getGlobalVariableAttributes().addAll((Collection<? extends VariableAttributeConfiguration>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL:
				setDocumentFeatureModel((DocumentFeatureModel)null);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				getTopFeaturesSelection().clear();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI:
				setDocumentFeatureModelURI(DOCUMENT_FEATURE_MODEL_URI_EDEFAULT);
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS:
				unsetSelectedContexts();
				return;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				getGlobalVariableAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL:
				return documentFeatureModel != null;
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__TOP_FEATURES_SELECTION:
				return topFeaturesSelection != null && !topFeaturesSelection.isEmpty();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__DOCUMENT_FEATURE_MODEL_URI:
				return DOCUMENT_FEATURE_MODEL_URI_EDEFAULT == null ? documentFeatureModelURI != null : !DOCUMENT_FEATURE_MODEL_URI_EDEFAULT.equals(documentFeatureModelURI);
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__SELECTED_CONTEXTS:
				return isSetSelectedContexts();
			case DfmconfPackage.DOCUMENT_FEATURE_MODEL_CONFIGURATION__GLOBAL_VARIABLE_ATTRIBUTES:
				return globalVariableAttributes != null && !globalVariableAttributes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (documentFeatureModelURI: ");
		result.append(documentFeatureModelURI);
		result.append(')');
		return result.toString();
	}

} //DocumentFeatureModelConfigurationImpl
