package es.upv.dsic.issi.dplfw.dfmconf.exceptions;

import org.eclipse.emf.ecore.util.EcoreUtil;

import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;

public class FeatureModelNotFoundException extends Exception {

	private static final long serialVersionUID = 1L;
	
	private DocumentFeatureModelConfiguration documentFeatureModelConfiguration;

	/**
	 * Default constructor
	 */
	public FeatureModelNotFoundException() {
	}
	
	/**
	 * Constructor
	 * @param documentFeatureModelConfiguration 
	 */
	public FeatureModelNotFoundException(DocumentFeatureModelConfiguration documentFeatureModelConfiguration) {
		this.documentFeatureModelConfiguration = documentFeatureModelConfiguration;
	}

	@Override
	public String getMessage() {
		return EcoreUtil.getURI(documentFeatureModelConfiguration).toString()  + " does not point to any DocumentFeatureModel element";
	}
	
}
