package es.upv.dsic.issi.dplfw.dfmconf.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.service.INotificationGenerator;

import es.upv.dsic.issi.dplfw.dfmconf.DfmconfPackage;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.ExcludesSelection;

public class ExcludesSelectionChange implements INotificationGenerator {

	public static String EXCLUDES_SELECTION_CHANGE_EVENT = "es.upv.dsic.issi.dplfw.dfmconf.excludesSelectionChange";
	
	@Override
	public Collection<Notification> generateNotifications(Collection<? extends Notification> notifications) {
		Collection<Notification> result = new ArrayList<Notification>();

		for (Iterator<? extends Notification> iter = notifications.iterator(); iter.hasNext();) {
			Notification notification = iter.next();
			Object notifier = notification.getNotifier();
			int eventType = notification.getEventType();
			Object feature = notification.getFeature();

			boolean selectionChanged = (eventType == Notification.SET || eventType == Notification.UNSET);
			
			if (notifier instanceof DocumentFeatureSelection 
					&& selectionChanged
					&& feature == DfmconfPackage.eINSTANCE.getDocumentFeatureSelection_Selected()) {
				
				DocumentFeatureSelection selection = (DocumentFeatureSelection) notifier;
				if (selection.getIsExcludedBy() != null &&
						!selection.getIsExcludedBy().isEmpty()) {
					for (ExcludesSelection parentExcludes : selection.getIsExcludedBy()) {
						result.add(
								new ENotificationImpl((InternalEObject) parentExcludes.getOwnerSelection(),
										EMFEventType.getInstance(EXCLUDES_SELECTION_CHANGE_EVENT).toNotificationType(),
										Notification.NO_FEATURE_ID, 
										null, null));
					}

				}
			}
		}

		return result;
	}

}
