package es.upv.dsic.issi.dplfw.dfmconf.constraints;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

import es.upv.dsic.issi.dplfw.dfm.FeatureType;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;


/**
 * Checks if a mandatory feature is selected when its parent is also selected
 * 
 * @author agomez
 *
 */
public class MandatoryConstraint extends AbstractModelConstraint {


	public IStatus validate(IValidationContext context) {
		
		EObject eObject = context.getTarget();
		EMFEventType eventType = context.getEventType();
	
		List<IStatus> statuses = new ArrayList<IStatus>();
		
		// In the case of batch mode.
		if (eventType == EMFEventType.NULL) {
			if (eObject instanceof DocumentFeatureSelection) {
				DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection) eObject;
				statuses.addAll(validateDocumentFeatureSelection(context, documentFeatureSelection));
			}
		// Live mode
		} else {
			Object newValue = context.getFeatureNewValue();
			// Check the requirements of the modified feature
			DocumentFeatureSelection documentFeatureSelection = (DocumentFeatureSelection) context.getTarget();
			if (newValue != Boolean.TRUE) {
				statuses.addAll(validateDocumentFeatureSelection(context, documentFeatureSelection));
			}
		}
		if (statuses != null && !statuses.isEmpty()) {
			return ConstraintStatus.createMultiStatus(context, statuses);
		}
		return context.createSuccessStatus();
	}

	protected List<IStatus> validateDocumentFeatureSelection(IValidationContext context, DocumentFeatureSelection documentFeatureSelection) {

		List<IStatus> statuses = new ArrayList<IStatus>();

		if (documentFeatureSelection.getSelected() != Boolean.TRUE &&
			documentFeatureSelection.getDocumentFeature().getType().equals(FeatureType.MANDATORY) &&
			( documentFeatureSelection.getParentSelection() == null  ||
			  documentFeatureSelection.getParentSelection().getSelected() == Boolean.TRUE )) {
				statuses.add(buildErrorStatus(context, documentFeatureSelection));
		}
		return statuses;
	}

	protected ConstraintStatus buildErrorStatus(IValidationContext context, DocumentFeatureSelection featureSelection) {
		
		return ConstraintStatus.createStatus(context, featureSelection,
				null,
				"Feature \"{0}\" is mandatory and must be selected",
				featureSelection.getDocumentFeature().getVisibleName());
	}
}
